<?php

return [
    'ctrl' => [
        'title' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_course',
        'label' => 'title',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'sortby' => 'sorting',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'id,title,subtitle,bodytext,teaser, ',
        'iconfile' => 'EXT:sg_courses/Resources/Public/Icons/tx_sgcourses_domain_model_course.gif'
    ],
    'interface' => [
        'showRecordFieldList' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, id, title, subtitle, path_segment, external_link, course_categories, images, external_link, teaser, bodytext, price_vvk, price_cashbox, price_reduced, locations, related, dates',
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, id, title, subtitle, path_segment, external_link, images, course_categories, teaser, bodytext, price_vvk, price_cashbox, price_reduced, locations, related, dates, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'special' => 'languages',
                'items' => [
                    [
                        'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.allLanguages',
                        -1,
                        'flags-multiple'
                    ]
                ],
                'default' => 0,
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['', 0],
                ],
                'foreign_table' => 'tx_sgcourses_domain_model_course',
                'foreign_table_where' => 'AND {#tx_sgcourses_domain_model_course}.{#pid}=###CURRENT_PID### AND {#tx_sgcourses_domain_model_course}.{#sys_language_uid} IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        0 => '',
                        1 => '',
                        'invertStateDisplay' => true
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],

        'id' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_course.id',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'title' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_course.title',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'subtitle' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_course.subtitle',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'external_link' => [
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_course.external_link',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputLink',
                'fieldControl' => [
                    'linkPopup' => [
                        'options' => [
                            'blindLinkOptions' => 'mail,spec,page,folder,tx_asproducts_topic,file',
                        ],
                    ],
                ]
            ],
        ],
        'images' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_course.images',
            'config' =>
                \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::getFileFieldTCAConfig(
                    'images',
                    [
                        'appearance' => [
                            'createNewRelationLinkTitle' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:images.addFileReference'
                        ],
                        'foreign_types' => [
                            '0' => [
                                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                            ],
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_TEXT => [
                                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                            ],
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_IMAGE => [
                                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                            ],
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_AUDIO => [
                                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                            ],
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_VIDEO => [
                                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                            ],
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_APPLICATION => [
                                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                            ]
                        ],
                        'maxitems' => 99
                    ],
                    $GLOBALS['TYPO3_CONF_VARS']['GFX']['imagefile_ext']
                ),

        ],
        'bodytext' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_course.bodytext',
            'config' => [
                'type' => 'text',
                'enableRichtext' => true,
                'richtextConfiguration' => 'default',
                'fieldControl' => [
                    'fullScreenRichtext' => [
                        'disabled' => false,
                    ],
                ],
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
            ],

        ],
        'teaser' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_course.teaser',
            'config' => [
                'type' => 'text',
                'enableRichtext' => true,
                'richtextConfiguration' => 'default',
                'fieldControl' => [
                    'fullScreenRichtext' => [
                        'disabled' => false,
                    ],
                ],
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
            ],

        ],
        'price_vvk' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_course.price_vvk',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'double2'
            ]
        ],
        'price_cashbox' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_course.price_cashbox',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'double2'
            ]
        ],
        'price_reduced' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_course.price_reduced',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'double2'
            ]
        ],
        'dates' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_course.dates',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_sgcourses_domain_model_coursedate',
                'foreign_field' => 'course',
                'foreign_sortby' => 'sorting',
                'maxitems' => 9999,
                'appearance' => [
                    'collapseAll' => 1,
                    'levelLinksPosition' => 'top',
                    'showSynchronizationLink' => 1,
                    'showPossibleLocalizationRecords' => 1,
                    'useSortable' => 1,
                    'showAllLocalizationLink' => 1
                ],
            ],

        ],
        'locations' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_event.locations',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [],
                'foreign_table' => 'tx_sgcourses_domain_model_courselocation',
            ],
        ],
        'related' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_course.related',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'enableMultiSelectFilterTextfield' => true,
                'foreign_table' => 'tx_sgcourses_domain_model_course',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 15,
                'multiple' => 0,
                'fieldControl' => [
                    'editPopup' => [
                        'disabled' => false,
                    ],
                    'addRecord' => [
                        'disabled' => false,
                    ],
                    'listModule' => [
                        'disabled' => true,
                    ],
                ],
            ],
        ],

        'course_categories' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_event.categories',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectTree',
                'foreign_table' => 'sys_category',
                'MM' => 'sys_category_record_mm',
                'MM_opposite_field' => 'items',
                'MM_match_fields' => [
                    'tablenames' => 'tx_sgcourses_domain_model_course',
                    'fieldname' => 'course_categories',
                ],
                'size' => 20,
                'treeConfig' => [
                    'parentField' => 'parent',
                    'appearance' => [
                        'showHeader' => true,
                        'expandAll' => true,
                        'maxLevels' => 99,
                        'nonSelectableLevels' => '0'
                    ],
                ],

            ],
        ],
        'path_segment' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_event.path_segment',
            'config' => [
                'type' => 'slug',
                'size' => 50,
                'generatorOptions' => [
                    'fields' => ['title'],
                    'replacements' => [
                        '/' => '-'
                    ],
                ],
                'fallbackCharacter' => '-',
                'eval' => 'unique',
                'default' => ''
            ]
        ],

        'course' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
    ],
];
