<?php

defined('TYPO3_MODE') || die('Access denied.');

call_user_func(
    function () {
        \TYPO3\CMS\Extbase\Utility\ExtensionUtility::configurePlugin(
            'SG.SgCourses',
            'Showcourses',
            [
                'Course' => 'list, listByCategory, show, booking'
            ],
            // non-cacheable actions
            [
                'Course' => ''
            ]
        );

        // wizards
        \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPageTSConfig(
            'mod {
            wizards.newContentElement.wizardItems.plugins {
                elements {
                    showcourses {
                        iconIdentifier = sg_courses-plugin-showcourses
                        title = LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sg_courses_showcourses.name
                        description = LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sg_courses_showcourses.description
                        tt_content_defValues {
                            CType = list
                            list_type = sgcourses_showcourses
                        }
                    }
                }
                show = *
            }
       }'
        );
        $iconRegistry = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\TYPO3\CMS\Core\Imaging\IconRegistry::class);

        $iconRegistry->registerIcon(
            'sg_courses-plugin-showcourses',
            \TYPO3\CMS\Core\Imaging\IconProvider\SvgIconProvider::class,
            ['source' => 'EXT:sg_courses/Resources/Public/Icons/user_plugin_showcourses.svg']
        );
    }
);

// Custom Routing Aspects Mapper
$GLOBALS['TYPO3_CONF_VARS']['SYS']['routing']['aspects']['DateValueMapper'] =
    \SG\SgCourses\Routing\Aspect\DateValueMapper::class;