<?php
/**
 * Created by PhpStorm.
 * User: Mark Kirstein
 * Date: 27.01.20
 * Time: 11:25
 */

namespace SG\SgCourses\Service;

use DateTime;

class DateService
{
    /**
     * @param array $dates
     * @return \SG\SgCourses\Domain\Model\CourseDate|null
     * @throws \Exception
     */
    public function todaysNearest($dates)
    {
        return $this->calculate($dates, true);
    }

    /**
     * @param array $dates
     * @return \SG\SgCourses\Domain\Model\CourseDate|null
     * @throws \Exception
     */
    public function upcoming($dates)
    {
        $returnValue = null;
        $today = $today = new DateTime('now');
        foreach ($dates as $date) {
            if ($date->getCourseStart()->getTimestamp() >= $today->getTimestamp()) {
                $returnValue[] = $date;
            }
        }
        return $returnValue;
    }

    /**
     * @param $dates
     * @param $nearest
     * @return \SG\SgCourses\Domain\Model\CourseDate|null
     * @throws \Exception
     */
    private function calculate($dates, $nearest)
    {
        $returnValue = null;
        $today = $today = new DateTime('now');
        foreach ($dates as $date) {
            if ($date->getCourseStart()->getTimestamp() >= $today->getTimestamp()) {
                $returnValue = $date;
                if ($nearest) {
                    break;
                }
            }
        }
        return $returnValue;
    }
}
