<?php
/**
 * Created by PhpStorm.
 * User: Mark Kirstein
 * Date: 12.02.20
 * Time: 08:44
 */

namespace SG\SgCourses\Routing\Aspect;

use DateTime;
use TYPO3\CMS\Core\Routing\Aspect\StaticMappableAspectInterface;

class DateValueMapper implements StaticMappableAspectInterface
{
    const DATE_FORMAT = 'd-m-Y-H-i';

    /**
     * {@inheritdoc}
     * @throws \Exception
     */
    public function generate(string $value): ?string
    {
        $date = new DateTime(date('c', (int)$value));

        if (!$date instanceof DateTime) {
            return null;
        } else {
            return $date->format(self::DATE_FORMAT);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function resolve(string $value): ?string
    {
        $date = DateTime::createFromFormat(self::DATE_FORMAT, $value);
        if (!$date instanceof DateTime) {
            return null;
        } else {
            return $date->format('U');
        }
    }
}
