<?php
namespace SG\SgCourses\Tests\Unit\Domain\Model;

/**
 * Test case.
 *
 * @author Mark Kirstein 
 */
class CourseDateTest extends \TYPO3\TestingFramework\Core\Unit\UnitTestCase
{
    /**
     * @var \SG\SgCourses\Domain\Model\CourseDate
     */
    protected $subject = null;

    protected function setUp()
    {
        parent::setUp();
        $this->subject = new \SG\SgCourses\Domain\Model\CourseDate();
    }

    protected function tearDown()
    {
        parent::tearDown();
    }

    /**
     * @test
     */
    public function getIdReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getId()
        );
    }

    /**
     * @test
     */
    public function setIdForStringSetsId()
    {
        $this->subject->setId('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'id',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getTitleReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getTitle()
        );
    }

    /**
     * @test
     */
    public function setTitleForStringSetsTitle()
    {
        $this->subject->setTitle('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'title',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getCourseStartReturnsInitialValueForDateTime()
    {
        self::assertEquals(
            null,
            $this->subject->getCourseStart()
        );
    }

    /**
     * @test
     */
    public function setCourseStartForDateTimeSetsCourseStart()
    {
        $dateTimeFixture = new \DateTime();
        $this->subject->setCourseStart($dateTimeFixture);

        self::assertAttributeEquals(
            $dateTimeFixture,
            'courseStart',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getCourseEndReturnsInitialValueForDateTime()
    {
        self::assertEquals(
            null,
            $this->subject->getCourseEnd()
        );
    }

    /**
     * @test
     */
    public function setCourseEndForDateTimeSetsCourseEnd()
    {
        $dateTimeFixture = new \DateTime();
        $this->subject->setCourseEnd($dateTimeFixture);

        self::assertAttributeEquals(
            $dateTimeFixture,
            'courseEnd',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getRegisterEndReturnsInitialValueForDateTime()
    {
        self::assertEquals(
            null,
            $this->subject->getRegisterEnd()
        );
    }

    /**
     * @test
     */
    public function setRegisterEndForDateTimeSetsRegisterEnd()
    {
        $dateTimeFixture = new \DateTime();
        $this->subject->setRegisterEnd($dateTimeFixture);

        self::assertAttributeEquals(
            $dateTimeFixture,
            'registerEnd',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getDateInfoReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getDateInfo()
        );
    }

    /**
     * @test
     */
    public function setDateInfoForStringSetsDateInfo()
    {
        $this->subject->setDateInfo('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'dateInfo',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getPriceVvkReturnsInitialValueForFloat()
    {
        self::assertSame(
            0.0,
            $this->subject->getPriceVvk()
        );
    }

    /**
     * @test
     */
    public function setPriceVvkForFloatSetsPriceVvk()
    {
        $this->subject->setPriceVvk(3.14159265);

        self::assertAttributeEquals(
            3.14159265,
            'priceVvk',
            $this->subject,
            '',
            0.000000001
        );
    }

    /**
     * @test
     */
    public function getPriceCashboxReturnsInitialValueForFloat()
    {
        self::assertSame(
            0.0,
            $this->subject->getPriceCashbox()
        );
    }

    /**
     * @test
     */
    public function setPriceCashboxForFloatSetsPriceCashbox()
    {
        $this->subject->setPriceCashbox(3.14159265);

        self::assertAttributeEquals(
            3.14159265,
            'priceCashbox',
            $this->subject,
            '',
            0.000000001
        );
    }

    /**
     * @test
     */
    public function getPriceReducedReturnsInitialValueForFloat()
    {
        self::assertSame(
            0.0,
            $this->subject->getPriceReduced()
        );
    }

    /**
     * @test
     */
    public function setPriceReducedForFloatSetsPriceReduced()
    {
        $this->subject->setPriceReduced(3.14159265);

        self::assertAttributeEquals(
            3.14159265,
            'priceReduced',
            $this->subject,
            '',
            0.000000001
        );
    }

    /**
     * @test
     */
    public function getBookedOutReturnsInitialValueForBool()
    {
        self::assertSame(
            false,
            $this->subject->getBookedOut()
        );
    }

    /**
     * @test
     */
    public function setBookedOutForBoolSetsBookedOut()
    {
        $this->subject->setBookedOut(true);

        self::assertAttributeEquals(
            true,
            'bookedOut',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getStatusReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getStatus()
        );
    }

    /**
     * @test
     */
    public function setStatusForStringSetsStatus()
    {
        $this->subject->setStatus('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'status',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getCourseCategoriesReturnsInitialValueForCourseCategory()
    {
        $newObjectStorage = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        self::assertEquals(
            $newObjectStorage,
            $this->subject->getCourseCategories()
        );
    }

    /**
     * @test
     */
    public function setCourseCategoriesForObjectStorageContainingCourseCategorySetsCourseCategories()
    {
        $courseCategory = new \SG\SgCourses\Domain\Model\CourseCategory();
        $objectStorageHoldingExactlyOneCourseCategories = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $objectStorageHoldingExactlyOneCourseCategories->attach($courseCategory);
        $this->subject->setCourseCategories($objectStorageHoldingExactlyOneCourseCategories);

        self::assertAttributeEquals(
            $objectStorageHoldingExactlyOneCourseCategories,
            'courseCategories',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function addCourseCategoryToObjectStorageHoldingCourseCategories()
    {
        $courseCategory = new \SG\SgCourses\Domain\Model\CourseCategory();
        $courseCategoriesObjectStorageMock = $this->getMockBuilder(\TYPO3\CMS\Extbase\Persistence\ObjectStorage::class)
            ->setMethods(['attach'])
            ->disableOriginalConstructor()
            ->getMock();

        $courseCategoriesObjectStorageMock->expects(self::once())->method('attach')->with(self::equalTo($courseCategory));
        $this->inject($this->subject, 'courseCategories', $courseCategoriesObjectStorageMock);

        $this->subject->addCourseCategory($courseCategory);
    }

    /**
     * @test
     */
    public function removeCourseCategoryFromObjectStorageHoldingCourseCategories()
    {
        $courseCategory = new \SG\SgCourses\Domain\Model\CourseCategory();
        $courseCategoriesObjectStorageMock = $this->getMockBuilder(\TYPO3\CMS\Extbase\Persistence\ObjectStorage::class)
            ->setMethods(['detach'])
            ->disableOriginalConstructor()
            ->getMock();

        $courseCategoriesObjectStorageMock->expects(self::once())->method('detach')->with(self::equalTo($courseCategory));
        $this->inject($this->subject, 'courseCategories', $courseCategoriesObjectStorageMock);

        $this->subject->removeCourseCategory($courseCategory);
    }

    /**
     * @test
     */
    public function getLocationsReturnsInitialValueForCourseLocation()
    {
        self::assertEquals(
            null,
            $this->subject->getLocations()
        );
    }

    /**
     * @test
     */
    public function setLocationsForCourseLocationSetsLocations()
    {
        $locationsFixture = new \SG\SgCourses\Domain\Model\CourseLocation();
        $this->subject->setLocations($locationsFixture);

        self::assertAttributeEquals(
            $locationsFixture,
            'locations',
            $this->subject
        );
    }
}
