<?php
namespace SG\SgCourses\Tests\Unit\Domain\Model;

/**
 * Test case.
 *
 * @author Mark Kirstein 
 */
class CourseTest extends \TYPO3\TestingFramework\Core\Unit\UnitTestCase
{
    /**
     * @var \SG\SgCourses\Domain\Model\Course
     */
    protected $subject = null;

    protected function setUp()
    {
        parent::setUp();
        $this->subject = new \SG\SgCourses\Domain\Model\Course();
    }

    protected function tearDown()
    {
        parent::tearDown();
    }

    /**
     * @test
     */
    public function getIdReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getId()
        );
    }

    /**
     * @test
     */
    public function setIdForStringSetsId()
    {
        $this->subject->setId('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'id',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getTitleReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getTitle()
        );
    }

    /**
     * @test
     */
    public function setTitleForStringSetsTitle()
    {
        $this->subject->setTitle('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'title',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getSubtitleReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getSubtitle()
        );
    }

    /**
     * @test
     */
    public function setSubtitleForStringSetsSubtitle()
    {
        $this->subject->setSubtitle('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'subtitle',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getImagesReturnsInitialValueForFileReference()
    {
        $newObjectStorage = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        self::assertEquals(
            $newObjectStorage,
            $this->subject->getImages()
        );
    }

    /**
     * @test
     */
    public function setImagesForFileReferenceSetsImages()
    {
        $image = new \TYPO3\CMS\Extbase\Domain\Model\FileReference();
        $objectStorageHoldingExactlyOneImages = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $objectStorageHoldingExactlyOneImages->attach($image);
        $this->subject->setImages($objectStorageHoldingExactlyOneImages);

        self::assertAttributeEquals(
            $objectStorageHoldingExactlyOneImages,
            'images',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function addImageToObjectStorageHoldingImages()
    {
        $image = new \TYPO3\CMS\Extbase\Domain\Model\FileReference();
        $imagesObjectStorageMock = $this->getMockBuilder(\TYPO3\CMS\Extbase\Persistence\ObjectStorage::class)
            ->setMethods(['attach'])
            ->disableOriginalConstructor()
            ->getMock();

        $imagesObjectStorageMock->expects(self::once())->method('attach')->with(self::equalTo($image));
        $this->inject($this->subject, 'images', $imagesObjectStorageMock);

        $this->subject->addImage($image);
    }

    /**
     * @test
     */
    public function removeImageFromObjectStorageHoldingImages()
    {
        $image = new \TYPO3\CMS\Extbase\Domain\Model\FileReference();
        $imagesObjectStorageMock = $this->getMockBuilder(\TYPO3\CMS\Extbase\Persistence\ObjectStorage::class)
            ->setMethods(['detach'])
            ->disableOriginalConstructor()
            ->getMock();

        $imagesObjectStorageMock->expects(self::once())->method('detach')->with(self::equalTo($image));
        $this->inject($this->subject, 'images', $imagesObjectStorageMock);

        $this->subject->removeImage($image);
    }

    /**
     * @test
     */
    public function getBodytextReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getBodytext()
        );
    }

    /**
     * @test
     */
    public function setBodytextForStringSetsBodytext()
    {
        $this->subject->setBodytext('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'bodytext',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getPriceVvkReturnsInitialValueForFloat()
    {
        self::assertSame(
            0.0,
            $this->subject->getPriceVvk()
        );
    }

    /**
     * @test
     */
    public function setPriceVvkForFloatSetsPriceVvk()
    {
        $this->subject->setPriceVvk(3.14159265);

        self::assertAttributeEquals(
            3.14159265,
            'priceVvk',
            $this->subject,
            '',
            0.000000001
        );
    }

    /**
     * @test
     */
    public function getPriceCashboxReturnsInitialValueForFloat()
    {
        self::assertSame(
            0.0,
            $this->subject->getPriceCashbox()
        );
    }

    /**
     * @test
     */
    public function setPriceCashboxForFloatSetsPriceCashbox()
    {
        $this->subject->setPriceCashbox(3.14159265);

        self::assertAttributeEquals(
            3.14159265,
            'priceCashbox',
            $this->subject,
            '',
            0.000000001
        );
    }

    /**
     * @test
     */
    public function getPriceReducedReturnsInitialValueForFloat()
    {
        self::assertSame(
            0.0,
            $this->subject->getPriceReduced()
        );
    }

    /**
     * @test
     */
    public function setPriceReducedForFloatSetsPriceReduced()
    {
        $this->subject->setPriceReduced(3.14159265);

        self::assertAttributeEquals(
            3.14159265,
            'priceReduced',
            $this->subject,
            '',
            0.000000001
        );
    }

    /**
     * @test
     */
    public function getDatesReturnsInitialValueForCourseDate()
    {
        $newObjectStorage = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        self::assertEquals(
            $newObjectStorage,
            $this->subject->getDates()
        );
    }

    /**
     * @test
     */
    public function setDatesForObjectStorageContainingCourseDateSetsDates()
    {
        $date = new \SG\SgCourses\Domain\Model\CourseDate();
        $objectStorageHoldingExactlyOneDates = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $objectStorageHoldingExactlyOneDates->attach($date);
        $this->subject->setDates($objectStorageHoldingExactlyOneDates);

        self::assertAttributeEquals(
            $objectStorageHoldingExactlyOneDates,
            'dates',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function addDateToObjectStorageHoldingDates()
    {
        $date = new \SG\SgCourses\Domain\Model\CourseDate();
        $datesObjectStorageMock = $this->getMockBuilder(\TYPO3\CMS\Extbase\Persistence\ObjectStorage::class)
            ->setMethods(['attach'])
            ->disableOriginalConstructor()
            ->getMock();

        $datesObjectStorageMock->expects(self::once())->method('attach')->with(self::equalTo($date));
        $this->inject($this->subject, 'dates', $datesObjectStorageMock);

        $this->subject->addDate($date);
    }

    /**
     * @test
     */
    public function removeDateFromObjectStorageHoldingDates()
    {
        $date = new \SG\SgCourses\Domain\Model\CourseDate();
        $datesObjectStorageMock = $this->getMockBuilder(\TYPO3\CMS\Extbase\Persistence\ObjectStorage::class)
            ->setMethods(['detach'])
            ->disableOriginalConstructor()
            ->getMock();

        $datesObjectStorageMock->expects(self::once())->method('detach')->with(self::equalTo($date));
        $this->inject($this->subject, 'dates', $datesObjectStorageMock);

        $this->subject->removeDate($date);
    }

    /**
     * @test
     */
    public function getRelatedReturnsInitialValueForCourse()
    {
        $newObjectStorage = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        self::assertEquals(
            $newObjectStorage,
            $this->subject->getRelated()
        );
    }

    /**
     * @test
     */
    public function setRelatedForObjectStorageContainingCourseSetsRelated()
    {
        $related = new \SG\SgCourses\Domain\Model\Course();
        $objectStorageHoldingExactlyOneRelated = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $objectStorageHoldingExactlyOneRelated->attach($related);
        $this->subject->setRelated($objectStorageHoldingExactlyOneRelated);

        self::assertAttributeEquals(
            $objectStorageHoldingExactlyOneRelated,
            'related',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function addRelatedToObjectStorageHoldingRelated()
    {
        $related = new \SG\SgCourses\Domain\Model\Course();
        $relatedObjectStorageMock = $this->getMockBuilder(\TYPO3\CMS\Extbase\Persistence\ObjectStorage::class)
            ->setMethods(['attach'])
            ->disableOriginalConstructor()
            ->getMock();

        $relatedObjectStorageMock->expects(self::once())->method('attach')->with(self::equalTo($related));
        $this->inject($this->subject, 'related', $relatedObjectStorageMock);

        $this->subject->addRelated($related);
    }

    /**
     * @test
     */
    public function removeRelatedFromObjectStorageHoldingRelated()
    {
        $related = new \SG\SgCourses\Domain\Model\Course();
        $relatedObjectStorageMock = $this->getMockBuilder(\TYPO3\CMS\Extbase\Persistence\ObjectStorage::class)
            ->setMethods(['detach'])
            ->disableOriginalConstructor()
            ->getMock();

        $relatedObjectStorageMock->expects(self::once())->method('detach')->with(self::equalTo($related));
        $this->inject($this->subject, 'related', $relatedObjectStorageMock);

        $this->subject->removeRelated($related);
    }
}
