<?php

namespace SG\SgCourses\Domain\Model;


/***
 *
 * This file is part of the "Courses" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2020 Mark Kirstein
 *
 ***/

/**
 * CourseDate
 */
class CourseDate extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    /**
     * id
     *
     * @var string
     */
    protected $id = '';

    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * courseStart
     *
     * @var \DateTime
     */
    protected $courseStart = null;

    /**
     * courseEnd
     *
     * @var \DateTime
     */
    protected $courseEnd = null;

    /**
     * registerEnd
     *
     * @var \DateTime
     */
    protected $registerEnd = null;

    /**
     * dateInfo
     *
     * @var string
     */
    protected $dateInfo = '';

    /**
     * dateInfo
     *
     * @var string
     */
    protected $dateInterval = '';

    /**
     * priceVvk
     *
     * @var float
     */
    protected $priceVvk = 0.0;

    /**
     * priceCashbox
     *
     * @var float
     */
    protected $priceCashbox = 0.0;

    /**
     * priceReduced
     *
     * @var float
     */
    protected $priceReduced = 0.0;

    /**
     * dateLabel
     *
     * @var bool
     */
    protected $dateLabel = false;

    /**
     * bookedOut
     *
     * @var bool
     */
    protected $bookedOut = false;

    /**
     * status
     *
     * @var string
     */
    protected $status = '';

    /**
     * @var \SG\SgCourses\Domain\Model\Course
     */
    protected $course = null;

    /**
     * Returns the id
     *
     * @return string $id
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Sets the id
     *
     * @param string $id
     * @return void
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * Returns the title
     *
     * @return string $title
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     *
     * @param string $title
     * @return void
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * Returns the courseStart
     *
     * @return \DateTime $courseStart
     */
    public function getCourseStart()
    {
        return $this->courseStart;
    }

    /**
     * Sets the courseStart
     *
     * @param \DateTime $courseStart
     * @return void
     */
    public function setCourseStart(\DateTime $courseStart)
    {
        $this->courseStart = $courseStart;
    }

    /**
     * Returns the courseEnd
     *
     * @return \DateTime $courseEnd
     */
    public function getCourseEnd()
    {
        return $this->courseEnd;
    }

    /**
     * Sets the courseEnd
     *
     * @param \DateTime $courseEnd
     * @return void
     */
    public function setCourseEnd(\DateTime $courseEnd)
    {
        $this->courseEnd = $courseEnd;
    }

    /**
     * Returns the registerEnd
     *
     * @return \DateTime $registerEnd
     */
    public function getRegisterEnd()
    {
        return $this->registerEnd;
    }

    /**
     * Sets the registerEnd
     *
     * @param \DateTime $registerEnd
     * @return void
     */
    public function setRegisterEnd(\DateTime $registerEnd)
    {
        $this->registerEnd = $registerEnd;
    }

    /**
     * Returns the dateInfo
     *
     * @return string $dateInfo
     */
    public function getDateInfo()
    {
        return $this->dateInfo;
    }

    /**
     * Sets the dateInfo
     *
     * @param string $dateInfo
     * @return void
     */
    public function setDateInfo($dateInfo)
    {
        $this->dateInfo = $dateInfo;
    }

    /**
     * Returns the priceVvk
     *
     * @return float $priceVvk
     */
    public function getPriceVvk()
    {
        return $this->priceVvk;
    }

    /**
     * Sets the priceVvk
     *
     * @param float $priceVvk
     * @return void
     */
    public function setPriceVvk($priceVvk)
    {
        $this->priceVvk = $priceVvk;
    }

    /**
     * Returns the priceCashbox
     *
     * @return float $priceCashbox
     */
    public function getPriceCashbox()
    {
        return $this->priceCashbox;
    }

    /**
     * Sets the priceCashbox
     *
     * @param float $priceCashbox
     * @return void
     */
    public function setPriceCashbox($priceCashbox)
    {
        $this->priceCashbox = $priceCashbox;
    }

    /**
     * Returns the priceReduced
     *
     * @return float $priceReduced
     */
    public function getPriceReduced()
    {
        return $this->priceReduced;
    }

    /**
     * Sets the priceReduced
     *
     * @param float $priceReduced
     * @return void
     */
    public function setPriceReduced($priceReduced)
    {
        $this->priceReduced = $priceReduced;
    }

    /**
     * Returns the bookedOut
     *
     * @return bool $bookedOut
     */
    public function getBookedOut()
    {
        return $this->bookedOut;
    }

    /**
     * Returns the boolean state of bookedOut
     *
     * @return bool
     */
    public function isBookedOut()
    {
        return $this->bookedOut;
    }

    /**
     * Sets the bookedOut
     *
     * @param bool $bookedOut
     * @return void
     */
    public function setBookedOut($bookedOut)
    {
        $this->bookedOut = $bookedOut;
    }

    /**
     * Returns the status
     *
     * @return string $status
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Sets the status
     *
     * @param string $status
     * @return void
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    /**
     * @return \SG\SgCourses\Domain\Model\Course
     */
    public function getCourse(): \SG\SgCourses\Domain\Model\Course
    {
        return $this->course;
    }

    /**
     * @param \SG\SgCourses\Domain\Model\Course $course
     */
    public function setCourse(\SG\SgCourses\Domain\Model\Course $course): void
    {
        $this->course = $course;
    }

    /**
     * @return string
     */
    public function getDateInterval(): string
    {
        return $this->dateInterval;
    }

    /**
     * @param string $dateInterval
     */
    public function setDateInterval(string $dateInterval): void
    {
        $this->dateInterval = $dateInterval;
    }

    /**
     * Returns the dateLabel
     *
     * @return bool $dateLabel
     */
    public function getDateLabel()
    {
        return $this->dateLabel;
    }

    /**
     * @return bool
     */
    public function isDateLabel(): bool
    {
        return $this->dateLabel;
    }

    /**
     * @param bool $dateLabel
     */
    public function setDateLabel(bool $dateLabel): void
    {
        $this->dateLabel = $dateLabel;
    }

}
