<?php
/**
 * Created by PhpStorm.
 * User: Mark Kirstein
 * Date: 25.07.19
 * Time: 10:28
 */

namespace SG\SgCourses\Service;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Database\Query\Restriction\HiddenRestriction;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Object\ObjectManager;
use TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;

class SearchService
{
    const ENTITY_PREFIX = 'SG\SgCourses\Domain\Model\\';

    /**
     * @param $className
     * @param $searchString
     * @return null
     * @throws \TYPO3\CMS\Extbase\Persistence\Generic\Exception
     */
    public static function search($className, $searchString)
    {
        $tables = GeneralUtility::trimExplode(',', $className);
        $properties = ['title', 'subtitle', 'bodytext', 'name'];
        $objectManager = GeneralUtility::makeInstance(ObjectManager::class);
        /** @var DataMapper $dataMapper */
        $dataMapper = $objectManager->get(DataMapper::class);
        $searchResult = [];
        foreach ($tables as $item) {
            $result = null;
            $searchProperties = [];

            $table = $dataMapper->getDataMap(self::ENTITY_PREFIX . $item)->getTableName();
            $mappingClass = self::ENTITY_PREFIX . $item;


            foreach ($properties as $key => $value) {
                if ($dataMapper->getDataMap(self::ENTITY_PREFIX . $item)->isPersistableProperty($value)) {
                    $searchProperties[] = strtolower(preg_replace(
                        '/(?<=\d)(?=[A-Za-z])|(?<=[A-Za-z])(?=\d)|(?<=[a-z])(?=[A-Z])/',
                        '_',
                        $value
                    ));
                }
            }
            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($table);
            $queryBuilder->getRestrictions()
                ->removeByType(HiddenRestriction::class);


            DebuggerUtility::var_dump($table);


            $constraints = [];

            foreach ($searchProperties as $property) {
                $constraints[] = $queryBuilder->expr()->like(
                    $property,
                    $queryBuilder->createNamedParameter('%' . $queryBuilder->escapeLikeWildcards($searchString) . '%')
                );
            }

            $result = $queryBuilder->select('*')->from($table)->orWhere(...$constraints);
            $tempResult = $dataMapper->map($mappingClass, $result->execute()->fetchAll());
            if (!empty($tempResult)) {
                $searchResult[] = $dataMapper->map($mappingClass, $result->execute()->fetchAll());
            }
        }
        return $searchResult;
    }
}
