<?php

namespace SG\SgCourses\Domain\Repository;


use TYPO3\CMS\Extbase\Persistence\Generic\QuerySettingsInterface;

/***
 *
 * This file is part of the "Courses" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2020 Mark Kirstein
 *
 ***/

/**
 * The repository for Courses
 */
class CourseRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
    protected $today;

    /**
     * @var array
     */
    protected $defaultOrderings = ['sorting' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING];

    /**
     * EventRepository constructor.
     * @param \TYPO3\CMS\Extbase\Object\ObjectManagerInterface $objectManager
     * @throws \Exception
     */
    public function __construct(\TYPO3\CMS\Extbase\Object\ObjectManagerInterface $objectManager)
    {
        parent::__construct($objectManager);

        /** @var QuerySettingsInterface $querySettings */
        $querySettings = $this->objectManager->get(QuerySettingsInterface::class);
        $this->setDefaultQuerySettings($querySettings->setRespectStoragePage(false));
        $this->today = new \DateTime('now');
    }

    /**
     * @param string $categories
     * @return int
     * @throws \TYPO3\CMS\Extbase\Persistence\Exception\InvalidQueryException
     */
    public function countUpcoming($categories)
    {
        $query = $this->createQuery();
        $query
            ->matching(
                $query->logicalAnd(
                    [
                        $query->greaterThan('dates.course_start', $this->today->getTimestamp()),
                        $query->contains('courseCategories', $categories)
                    ]
                )
            );

        return $query->execute()->count();
    }

    /**
     * @param int $limit
     * @param string $categories
     * @param int $offset
     * @return array|\TYPO3\CMS\Extbase\Persistence\QueryResultInterface
     * @throws \TYPO3\CMS\Extbase\Persistence\Exception\InvalidQueryException
     */
    public function findAdditional($limit, $categories, $offset)
    {
        $query = $this->createQuery();
        $query
            ->matching(
                $query->logicalAnd(
                    [
                        $query->greaterThan('dates.course_start', $this->today->getTimestamp()),
                        $query->contains('courseCategories', $categories)
                    ]
                )
            )
            ->setLimit((int)$limit)
            ->setOffset((int)$offset);

        return $query->execute();
    }
}
