<?php

namespace SG\SgCourses\Domain\Repository;


use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;

/***
 *
 * This file is part of the "Courses" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2020 Mark Kirstein
 *
 ***/

/**
 * The repository for Courses
 */
class CourseDateRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{

    /**
     * @var array
     */
    protected $defaultOrderings = ['course_start' => QueryInterface::ORDER_ASCENDING];

    /**
     * @param int $limit
     * @param string $categories
     * @param int $offset
     * @return array|\TYPO3\CMS\Extbase\Persistence\QueryResultInterface
     * @throws \TYPO3\CMS\Extbase\Persistence\Exception\InvalidQueryException
     */
    public function findByFilter($limit, $categories, $offset)
    {
        $today = new \DateTime('now');
        $query = $this->createQuery();
        $categoryConstraint = $this->categoryConstraint($categories, $query);

        $query->matching($query->logicalAnd([
            $query->greaterThanOrEqual('course_start', (int)$today->getTimestamp()),
            $query->equals('course.hidden', 0),
            $query->equals('course.deleted', 0),
            $query->logicalOr($categoryConstraint)

        ]))->setLimit((int)$limit)
            ->setOffset((int)$offset);

        return $query->execute();
    }

    /**
     * @param string $categories
     * @param $query
     * @return array
     */
    public function categoryConstraint($categories, $query)
    {
        $constraint = [];
        if (strlen($categories) > 0) {
            $categoriesArray = GeneralUtility::intExplode(',', $categories);
            foreach ($categoriesArray as $category) {
                $constraint[] = $query->contains('course.courseCategories', $category);
            }
        } else {
            $constraint[] = $query->greaterThanOrEqual('course.courseCategories', 0);
        }

        return $constraint;
    }
}
