<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_coursedate',
        'label' => 'course_start',
        'label_alt' => 'register_end',
        'label_alt_force' => 1,
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'sortby' => 'sorting',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'id,title,date_info,status',
        'iconfile' => 'EXT:sg_courses/Resources/Public/Icons/tx_sgcourses_domain_model_coursedate.gif'
    ],
    'interface' => [
        'showRecordFieldList' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, title, date_label, course_start, course_end, register_end, date_interval, date_info, price_vvk, price_cashbox, price_reduced, booked_out, status',
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, title, date_label, course_start, course_end, register_end, date_interval, date_info, price_vvk, price_cashbox, price_reduced, booked_out, status, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'special' => 'languages',
                'items' => [
                    [
                        'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.allLanguages',
                        -1,
                        'flags-multiple'
                    ]
                ],
                'default' => 0,
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['', 0],
                ],
                'foreign_table' => 'tx_sgcourses_domain_model_coursedate',
                'foreign_table_where' => 'AND {#tx_sgcourses_domain_model_coursedate}.{#pid}=###CURRENT_PID### AND {#tx_sgcourses_domain_model_coursedate}.{#sys_language_uid} IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        0 => '',
                        1 => '',
                        'invertStateDisplay' => true
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],

        'title' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_coursedate.title',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'course_start' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_coursedate.course_start',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'size' => 10,
                'eval' => 'datetime',
                'default' => 0
            ],
        ],
        'course_end' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_coursedate.course_end',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'size' => 10,
                'eval' => 'datetime',
                'default' => 0
            ],
        ],
        'register_end' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_coursedate.register_end',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'size' => 7,
                'eval' => 'date',
                'default' => 0
            ],
        ],
        'date_info' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_coursedate.date_info',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'date_interval' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_coursedate.date_interval',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'price_vvk' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_coursedate.price_vvk',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'double2'
            ]
        ],
        'price_cashbox' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_coursedate.price_cashbox',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'double2'
            ]
        ],
        'price_reduced' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_coursedate.price_reduced',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'double2'
            ]
        ],
        'booked_out' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_coursedate.booked_out',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        '0' => 'LLL:EXT:lang/locallang_core.xlf:labels.enabled'
                    ]
                ],
                'default' => 0,
            ]
        ],
        'date_label' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_coursedate.date_label',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        '0' => 'LLL:EXT:lang/locallang_core.xlf:labels.enabled'
                    ]
                ],
                'default' => 0,
            ]
        ],
        'status' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_courses/Resources/Private/Language/locallang_db.xlf:tx_sgcourses_domain_model_coursedate.status',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],

        'course' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_events/Resources/Private/Language/locallang_db.xlf:tx_sgevents_domain_model_event.locations',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [],
                'foreign_table' => 'tx_sgcourses_domain_model_course',
            ],
        ],
    ],
];
