<?php

namespace SG\SgCourses\ViewHelpers;

use SG\SgCourses\Service\DateService;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class DateViewHelper extends AbstractViewHelper
{

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $returnValue = null;
        /** @var DateService $dateService */
        $dateService = GeneralUtility::makeInstance(DateService::class);


        if ($arguments['dates'] !== null && $arguments['type'] === 'nearest') {
            try {
                $returnValue = $dateService->todaysNearest($arguments['dates']);
            } catch (\Exception $e) {
            }
        } else {
            if ($arguments['dates'] !== null && $arguments['type'] === 'upcoming') {
                try {
                    $returnValue = $dateService->upcoming($arguments['dates']);
                } catch (\Exception $e) {
                }
            }
        }
        return $returnValue;
    }

    public function initializeArguments()
    {
        $this->registerArgument('type', 'string', 'type of result (nearest date or upcoming dates)', 1);
        $this->registerArgument('dates', 'array', 'events dates', 1);
    }
}
