<?php
namespace Smply\SgContact\Provider;

use FluidTYPO3\Flux\Provider\AbstractProvider;
use FluidTYPO3\Flux\Provider\ProviderInterface;

class ListConfigurationProvider extends AbstractProvider implements ProviderInterface
{

    /**
     * @var string
     */
    protected $tableName = 'tt_content';

    /**
     * @var string
     */
    protected $fieldName = 'pi_flexform';

    /**
     * @var string
     */
    protected $listType = 'sgcontact_pi2';

    /**
     * @var string
     */
    protected $contentObjectType = 'list';

    /**
     * @var string
     */
    protected $extensionKey = 'Smply.SgContact';

    /**
     * @var \Smply\SgContact\Domain\Repository\PersonRepository
     * @inject
     */
    protected $personRepository;

    /**
     * @var \TYPO3\CMS\Extbase\Object\ObjectManager
     * @inject
     */
    protected $objectManager;

    /**
     * @var array
     */
    protected $persons = array();

    protected function initialize()
    {
        $querySettings = $this->objectManager->get('TYPO3\\CMS\\Extbase\\Persistence\\Generic\\Typo3QuerySettings');
        $querySettings->setRespectStoragePage(FALSE);
        $this->personRepository->setDefaultQuerySettings($querySettings);
        $this->personRepository->setDefaultOrderings(array(
            'lastName' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
            'firstName' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
        ));
        $persons = $this->personRepository->findAll();
        foreach ($persons as $person){
            $this->persons[$person->getUid()] = $person->getLastname() . ', ' . $person->getFirstname() ;
        }
//        echo "<pre>";print_r($this->persons);die();
    }



    public function getForm(array $row)
    {
        $this->initialize();
        /**
         * @var \FluidTYPO3\Flux\Form $form
         * @var \FluidTYPO3\Flux\Form\Container\Sheet $sheet
         * @var \FluidTYPO3\Flux\Form\Field\Select $contactSelect
         */
        $flexFormService = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\\CMS\\Extbase\\Service\\FlexFormService');
        $fields = $flexFormService->convertFlexFormContentToArray($row['pi_flexform']);

        $form = \FluidTYPO3\Flux\Form::create();
        $form->setName('dynamicProperties');

        $sheet = $form->createContainer('FluidTYPO3\Flux\Form\Container\Sheet', 'general', 'Allgemein');
        $sheet->setDisableLocalLanguageLabels(true);
        $sheet->createField('FluidTYPO3\Flux\Form\Field\Input','sectionCount','Wieviele Sektionen sollen angelegt werden?');

        if (is_numeric($fields['sectionCount']) && $fields['sectionCount'] > 0){
            $sectionCount = $fields['sectionCount'];
            for($i = 1; $i <= $sectionCount; $i++){
                $sheet = $form->createContainer('FluidTYPO3\Flux\Form\Container\Sheet', 'section_'.$i, 'Sektion '.$i);
                $sheet->setDisableLocalLanguageLabels(true);
                $sheet->createField('FluidTYPO3\Flux\Form\Field\Input', 'headline_'.$i, 'Überschrift der ' . $i . '. Sektion');
                $contactSelect = $sheet->createField('FluidTYPO3\Flux\Form\Field\Select', 'contacts_'.$i, 'Personen für die '.$i.'. Sektion');
                $contactSelect->setMultiple(true);
                $contactSelect->setSize(10);
                $contactSelect->setMinItems(0);
                $contactSelect->setMaxItems(99);
                $contactSelect->setItems($this->persons);
                $contactSelect->setRenderType('selectMultipleSideBySide');
            }
        }
        return $form;
    }
}
