<?php
namespace Smply\SgContact\Controller;

use TYPO3\CMS\Core\Utility\GeneralUtility;

  /***************************************************************
   *
   *  Copyright notice
   *
   *  (c) 2016 Daniel Hoffmann <hoffmann@smply.gd>, smply.gd GmbH
   *           Marc Saleiko <saleiko@smply.gd>, smply.gd GmbH
   *
   *  All rights reserved
   *
   *  This script is part of the TYPO3 project. The TYPO3 project is
   *  free software; you can redistribute it and/or modify
   *  it under the terms of the GNU General Public License as published by
   *  the Free Software Foundation; either version 3 of the License, or
   *  (at your option) any later version.
   *
   *  The GNU General Public License can be found at
   *  http://www.gnu.org/copyleft/gpl.html.
   *
   *  This script is distributed in the hope that it will be useful,
   *  but WITHOUT ANY WARRANTY; without even the implied warranty of
   *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   *  GNU General Public License for more details.
   *
   *  This copyright notice MUST APPEAR in all copies of the script!
   ***************************************************************/

/**
 * ContactController
 */
class ContactController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{

  /**
   * categoryRepository
   *
   * @var \Smply\SgContact\Domain\Repository\CategoryRepository
   * @inject
   */
  protected $categoryRepository = NULL;

  /**
   * departmentRepository
   *
   * @var \Smply\SgContact\Domain\Repository\DepartmentRepository
   * @inject
   */
  protected $departmentRepository = NULL;

  /**
   * personRepository
   *
   * @var \Smply\SgContact\Domain\Repository\PersonRepository
   * @inject
   */
  protected $personRepository = NULL;

  /**
   * sectorRepository
   *
   * @var \Smply\SgContact\Domain\Repository\SectorRepository
   * @inject
   */
  protected $sectorRepository = NULL;

  /**
   * Action for display a single Contact
   *
   * @return string
   */
  public function singleAction(){
    $cacheIdentifier = 'person_'.$this->settings['single']['person'].'_'.implode('', $this->settings['show']).'_'.$this->settings['single']['layout'];
    if (($content = GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Cache\\CacheManager')->getCache('sgcontact_cache')->get($cacheIdentifier)) === FALSE) {
      if (is_numeric($this->settings['single']['person'])){
        $person = $this->personRepository->findByUid($this->settings['single']['person']);
        if ($person instanceof \Smply\SgContact\Domain\Model\Person){
          $contentObjectData = $this->configurationManager->getContentObject()->data;

          $this->view->assign('contentObjectData', $contentObjectData);
          $this->view->assign('person', $person);

          $content = $this->view->render();

          $tags = array('persons');
          $lifetime = 86400;
          GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Cache\\CacheManager')->getCache('sgcontact_cache')->set($cacheIdentifier, $content, $tags, $lifetime);
        }
      }
    }
    return $content;
  }

  public function categoryAction(){
    $cacheIdentifier = 'category_'.$this->settings['category']['item'].'_'.implode('', $this->settings['show']).'_'.$this->settings['category']['layout'];
    if (($content = GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Cache\\CacheManager')->getCache('sgcontact_cache')->get($cacheIdentifier)) === FALSE) {
      if (is_numeric($this->settings['category']['item'])){
        $category = $this->categoryRepository->findByUid($this->settings['category']['item']);
        if ($category instanceof \Smply\SgContact\Domain\Model\Category){
          $this->view->assign('category', $category);
          $persons = $this->personRepository->findByCategory($category);
          $this->view->assign('persons', $persons);
          $content = $this->view->render();

          $tags = array('category');
          $lifetime = 86400;
          GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Cache\\CacheManager')->getCache('sgcontact_cache')->set($cacheIdentifier, $content, $tags, $lifetime);
        }
      }
    }
    return $content;
  }

  public function searchAction()
  {
    $allSectors = $this->sectorRepository->findAll();
    $value = false;
    $sector = false;
    $persons = false;
    $requestSent = false;
    $requestSectorFound = false;
    $resultCount = 0;


    if( $this->request->hasArgument('sector') )
    {
      $value = $this->request->getArgument('sector');
    }

    if( $value !== false && $value !== '' )
    {
      $requestSent = true;
      // get the specified sector
      $sector = $this->sectorRepository->findByUid( $value );
      if( $sector instanceof \Smply\SgContact\Domain\Model\Sector )
      {
        $requestSectorFound = true;
        // get all persons that match the selected sector
        $resultCount = $sector->getResponsibilities()->count();
      }
    }
    $this->view->assign('allSectors', $allSectors );
    $this->view->assign('requestSent', $requestSent );
    $this->view->assign('requestSectorFound', $requestSectorFound );
    $this->view->assign('selectedValue', $value );
    $this->view->assign('selectedSector', $sector );
    $this->view->assign('selectedPersons', $persons );
    $this->view->assign('resultCount', $resultCount );
  }

  public function multiAction(){
    $cacheIdentifier = 'multi_'.$this->settings['multi']['layout'].str_replace(',','-',$this->settings['multi']['persons']).'_'.implode('', $this->settings['show']);
    if (($content = GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Cache\\CacheManager')->getCache('sgcontact_cache')->get($cacheIdentifier)) === FALSE) {
      $persons = array();
      if ($this->settings['multi']['persons'] != ''){
        $personsUids = explode(',', $this->settings['multi']['persons']);
        foreach ($personsUids as $personUid){
          if (is_numeric($personUid)){
            $person = $this->personRepository->findByUid($personUid);
            if ($person instanceof \Smply\SgContact\Domain\Model\Person){
              array_push($persons, $person);
            }
          }
        }
        $this->view->assign('persons', $persons);
        $content = $this->view->render();

        $tags = array('multi');
        $lifetime = 86400;
        GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Cache\\CacheManager')->getCache('sgcontact_cache')->set($cacheIdentifier, $content, $tags, $lifetime);

      }
    }
    return $content;
  }

  public function listAction(){
      $dataArray = array();
      $flexFormService = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\\CMS\\Extbase\\Service\\FlexFormService');
      $fields = $flexFormService->convertFlexFormContentToArray($this->configurationManager->getContentObject()->data['pi_flexform']);
      for ($i=1;$i<= $fields['sectionCount'];$i++){
          if ($fields['headline_'.$i] != '' && $fields['contacts_'.$i] != ''){
              $tempContacts = array();
              $personUids = explode(',', $fields['contacts_'.$i]);
              foreach ($personUids as $personUid){
                  $person = $this->personRepository->findByUid($personUid);
                  if ($person instanceof \Smply\SgContact\Domain\Model\Person){
                      array_push($tempContacts, $person);
                  }
              }

              array_push($dataArray, array(
                  'title' => $fields['headline_'. $i],
                  'contacts' => $tempContacts
              ));
          }
      }
      $this->view->assign('data', $dataArray);
  }

}