<?php

namespace SG\SgContact\Hooks;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Object\ObjectManager;

class PageLayoutView implements \TYPO3\CMS\Backend\View\PageLayoutViewDrawItemHookInterface {
	
	/**
	 * @var \TYPO3\CMS\Extbase\Object\ObjectManager
	 */
	protected $objectManager;
	
	/**
	 * PageLayoutView constructor.
	 * Init object manager, so we can use items repository
	 */
	public function __construct()
	{
		$pluginConfiguration = array(
			'extensionName' => 'sg_contact',
			'pluginName' => 'Pi1'
		);
		$bootstrap = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Core\Bootstrap');
		$bootstrap->initialize($pluginConfiguration);
		$this->objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');
	}
	
	/**
	 * @param \TYPO3\CMS\Backend\View\PageLayoutView $parentObject
	 * @param bool                                   $drawItem
	 * @param string                                 $headerContent Holds the CE Title below header line
	 * @param string                                 $itemContent Content below $headerContent. holds jumpmark on default
	 * @param array                                  $row
	 */
	public function preProcess(\TYPO3\CMS\Backend\View\PageLayoutView &$parentObject, &$drawItem, &$headerContent, &$itemContent, array &$row)
    {
        $controllerAction = '';
        if ($row['list_type'] !== 'sgcontact_pi1') {
            return;
        }
	
	    // do not draw default plugin template/layout
        $drawItem = FALSE;


        $flexform = $row['pi_flexform'];
        $xml = simplexml_load_string($flexform);
        $layout = '';

        foreach ($xml->data->sheet->language->children() as $field){
            if ((isset($field['index']))&&($field['index'] == 'switchableControllerActions')){
                $controllerAction = strval($field->value);
            }
            if ((isset($field['index']))&&($field['index'] == 'settings.single.person')){
              $personUid = strval($field->value);
            }
	        if ((isset($field['index']))&& ( strpos($field['index'], '.layout') !== false )){
		        $layout = strval($field->value);
	        }
            if ((isset($field['index']))&&($field['index'] == 'settings.category.item')){
              $categoryUid = strval($field->value);
            }
        }

        switch ($controllerAction){
            case "Contact->single":
                $additionalHeaderContent = ' - ' . \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate('LLL:EXT:sg_contact/Resources/Private/Language/locallang_flexform_pi1.xlf:layout.single', 'sg_contact');
                $additionalHeaderContent .= '<br>'.\TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate('LLL:EXT:sg_contact/Resources/Private/Language/locallang_flexform_pi1.xlf:layout', 'sg_contact').': '.$layout;
                if (is_numeric($personUid)){
                  $personRepository = $this->objectManager->get('SG\SgContact\Domain\Repository\PersonRepository');
                  $person = $personRepository->findByUid($personUid);
                  if ($person instanceof \SG\SgContact\Domain\Model\Person){
                    $additionalHeaderContent .= '<br />'. $person->getFirstName() . ' ' . $person->getLastName();
                  }
                }

                break;
            case 'Contact->category':
                $additionalHeaderContent = ' - '. \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate('LLL:EXT:sg_contact/Resources/Private/Language/locallang_flexform_pi1.xlf:layout.category', 'sg_contact');
	            $additionalHeaderContent .= '<br>'.\TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate('LLL:EXT:sg_contact/Resources/Private/Language/locallang_flexform_pi1.xlf:layout', 'sg_contact').': '.$layout;
                if (is_numeric($categoryUid)){
                  $categoryRepository = $this->objectManager->get('SG\SgContact\Domain\Repository\CategoryRepository');
                  $category = $categoryRepository->findByUid($categoryUid);
                  if ($category instanceof \SG\SgContact\Domain\Model\Category){
                    $additionalHeaderContent .= '<br />'. $category->getCaption();
                  }
                }
                break;
            case 'Contact->search':
                $additionalHeaderContent = ' - ' . \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate('LLL:EXT:sg_contact/Resources/Private/Language/locallang_flexform_pi1.xlf:layout.search', 'sg_contact');
	            $additionalHeaderContent .= '<br>'.\TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate('LLL:EXT:sg_contact/Resources/Private/Language/locallang_flexform_pi1.xlf:layout', 'sg_contact').': '.$layout;
                break;
			case 'Contact->multi':
			    $additionalHeaderContent = ' - ' . \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate('LLL:EXT:sg_contact/Resources/Private/Language/locallang_flexform_pi1.xlf:layout.multi', 'sg_contact');
			    $additionalHeaderContent .= '<br>'.\TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate('LLL:EXT:sg_contact/Resources/Private/Language/locallang_flexform_pi1.xlf:layout', 'sg_contact').': '.$layout;
			    break;
            default:
                $additionalHeaderContent = '';
                break;
        }

        $headerContent = '<b>sg.contact'. $additionalHeaderContent. "</b><br>";
    }
}