<?php

namespace SG\SgContact\Util;

use SG\SgContact\Domain\Repository\CategoryRepository;
use SG\SgContact\Domain\Repository\DepartmentRepository;
use SG\SgContact\Domain\Repository\PersonRepository;
use TYPO3\CMS\Backend\Utility\BackendUtility;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Core\Bootstrap;
use TYPO3\CMS\Extbase\Object\ObjectManager;

class AddFields implements SingletonInterface{

    /**
     * @var \TYPO3\CMS\Extbase\Object\ObjectManager
     */
    protected $objectManager;

    public function __construct(){
        $pluginConfiguration = array(
            'vendorName' => 'SG',
            'extensionName' => 'sgcontact',
            'pluginName' => 'Pi1'
        );

        $bootstrap = GeneralUtility::makeInstance(Bootstrap::class);
        $bootstrap->initialize($pluginConfiguration);

        $this->objectManager = GeneralUtility::makeInstance(ObjectManager::class);

    }

    /**
     * Returns all activated Categories for use in Flexform
     *
     * @param $config
     * @return mixed
     */
    public function addCategories($config){
        /**
         * @var $category \SG\SgContact\Domain\Model\Category
         * @var $categoryRepository \SG\SgContact\Domain\Repository\CategoryRepository
         */
        $categoryRepository = $this->objectManager->get(CategoryRepository::class);
        $optionList = array();

        foreach($categoryRepository->findAll() as $category){
            $optionList[] = array(
                0 => $category->getTitle(),
                1 => $category->getUid()
            );
        }
        $config['items'] = array_merge($config['items'],$optionList);
        return $config;
    }

    /**
     * Returns all activated Departments for use in Flexform
     *
     * @param $config
     * @return mixed
     */
    public function addDepartments($config){
        /**
         * @var $department \SG\SgContact\Domain\Model\Department
         * @var $departmentRepository \SG\SgContact\Domain\Repository\DepartmentRepository
         */
        $departmentRepository = $this->objectManager->get(DepartmentRepository::class);
        $optionList = array();

        foreach($departmentRepository->findAll() as $department){
            $optionList[] = array(
                0 => $department->getTitle(),
                1 => $department->getUid()
            );
        }
        $config['items'] = array_merge($config['items'],$optionList);
        return $config;
    }

    /**
     * Returns all activated Persons for use in Flexform
     *
     * @param $config
     * @return mixed
     */
    public function addPersons($config){
        /**
         * @var $person \SG\SgContact\Domain\Model\Person
         * @var $personRepository \SG\SgContact\Domain\Repository\PersonRepository
         */
        $personRepository = $this->objectManager->get(PersonRepository::class);
        $optionList = array();

        foreach($personRepository->findAll() as $person){
            $optionList[] = array(
                0 => $person->getLastName(). ', '. $person->getFirstName() . ' (' . $person->getContactId() . ')',
                1 => $person->getUid()
            );
        }
        $config['items'] = array_merge($config['items'],$optionList);
        return $config;
    }

    /**
     * Adds Template Layouts from PageTS to Flexform of Single Plugin
     *
     * @param $config
     * @return mixed
     */
    public function addSingleTemplateLayouts($config){
        $pagesTsConfig = BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);
        if (isset($pagesTsConfig['tx_sgcontact.']['layouts.']['single.']) && is_array($pagesTsConfig['tx_sgcontact.']['layouts.']['single.'])) {
            $templateLayouts = $pagesTsConfig['tx_sgcontact.']['layouts.']['single.'];
        }else{
            $templateLayouts = array();
            $optionList = array();
        }
        foreach($templateLayouts as $key => $value){
            $optionList[] = array(
                0 => $value,
                1 => $key
            );
        }
        $config['items'] = array_merge($config['items'],$optionList);


        return $config;
    }


    /**
     * Adds Template Layouts from PageTS to Flexform of Category Plugin
     *
     * @param $config
     * @return mixed
     */
    public function addCategoryTemplateLayouts($config){
        $pagesTsConfig = BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);
        if (isset($pagesTsConfig['tx_sgcontact.']['layouts.']['category.']) && is_array($pagesTsConfig['tx_sgcontact.']['layouts.']['category.'])) {
            $templateLayouts = $pagesTsConfig['tx_sgcontact.']['layouts.']['category.'];
        }else{
            $templateLayouts = array();
            $optionList = array();
        }
        foreach($templateLayouts as $key => $value){
            $optionList[] = array(
                0 => $value,
                1 => $key
            );
        }
        $config['items'] = array_merge($config['items'],$optionList);


        return $config;
    }

    /**
     * Adds Template Layouts from PageTS to Flexform of Multi Plugin
     *
     * @param $config
     * @return mixed
     */
    public function addMultiTemplateLayouts($config){
        $pagesTsConfig = BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);
        if (isset($pagesTsConfig['tx_sgcontact.']['layouts.']['multi.']) && is_array($pagesTsConfig['tx_sgcontact.']['layouts.']['multi.'])) {
            $templateLayouts = $pagesTsConfig['tx_sgcontact.']['layouts.']['multi.'];
        }else{
            $templateLayouts = array();
            $optionList = array();
        }
        foreach($templateLayouts as $key => $value){
            $optionList[] = array(
                0 => $value,
                1 => $key
            );
        }
        $config['items'] = array_merge($config['items'],$optionList);


        return $config;
    }
}