<?php
namespace Smply\SgContact\Controller;

class ManagementController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{
  /**
   * @var \TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager
   * @inject
   */
  protected $persistenceManager;

  /**
   * @var \Smply\SgContact\Domain\Repository\CategoryRepository
   * @inject
   */
  protected $categoryRepository;

  /**
   * @var \Smply\SgContact\Domain\Repository\DepartmentRepository
   * @inject
   */
  protected $departmentRepository;

  /**
   * @var \Smply\SgContact\Domain\Repository\PersonRepository
   * @inject
   */
  protected $personRepository;

  /**
   * @var \Smply\SgContact\Domain\Repository\RoleRepository
   * @inject
   */
  protected $roleRepository;

  /**
   * @var \Smply\SgContact\Domain\Repository\ResponsibilityRepository
   * @inject
   */
  protected $responsibilityRepository;

  /**
   * @var \Smply\SgContact\Domain\Repository\SectorRepository
   * @inject
   */
  protected $sectorRepository;

  public function indexAction(){}

  public function importPersonsAction(){
    /**
     * @var $category \Smply\SgContact\Domain\Model\Category
     * @var $department \Smply\SgContact\Domain\Model\Department
     * @var $person \Smply\SgContact\Domain\Model\Person
     */
    if($this->request->hasArgument('submit')){
      if ($this->request->hasArgument('persons') && $this->request->getArgument('persons')['error'] == 0){
        $personsFile = $this->request->getArgument('persons');
        $personsFilename = uniqid('persons');
        move_uploaded_file($personsFile['tmp_name'], PATH_site.'typo3temp/'.$personsFilename.'.csv');

        // Import or Update Categories
        if (($handle = fopen(PATH_site.'typo3temp/'.$personsFilename.'.csv', "r")) !== FALSE) {
          $categoryTitlesForDatabase = array();
          while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
            $categoryTitles = explode(',',$data[9]);
            foreach ($categoryTitles as $categoryTitle){
              $categoryTitlesForDatabase[$categoryTitle] = $categoryTitle;
            }
          }
          fclose($handle);

          foreach ($categoryTitlesForDatabase as $titleToCheck){
            $category = $this->categoryRepository->findOneByTitle($titleToCheck);
            if (!$category instanceof \Smply\SgContact\Domain\Model\Category){
              $category = $this->objectManager->get('Smply\SgContact\Domain\Model\Category');
              $category->setTitle($titleToCheck);
              $category->setCaption($titleToCheck);
              $this->categoryRepository->add($category);
            }
          }
        }

        // Import or Update Departments
        if (($handle = fopen(PATH_site.'typo3temp/'.$personsFilename.'.csv', "r")) !== FALSE) {
          $departmentTitlesForDatabase = array();
          while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
            $departmentTitlesForDatabase[$data[5]] = $data[5];
          }
          fclose($handle);

          foreach ($departmentTitlesForDatabase as $titleToCheck){
            $department = $this->departmentRepository->findOneByTitle($titleToCheck);
            if (!$department instanceof \Smply\SgContact\Domain\Model\Department){
              $department = $this->objectManager->get('Smply\SgContact\Domain\Model\Department');
              $department->setTitle($titleToCheck);
              $department->setCaption($titleToCheck);
              $this->departmentRepository->add($department);
            }
          }
        }

        // Persist all to Save Categories and Departments
        $this->persistenceManager->persistAll();

        // Import or Update Persons
        if (($handle = fopen(PATH_site.'typo3temp/'.$personsFilename.'.csv', "r")) !== FALSE) {
          while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
            $person = $this->personRepository->findOneByContactId($data[0]);
            if (!$person instanceof \Smply\SgContact\Domain\Model\Person){
              $person = $this->objectManager->get('Smply\SgContact\Domain\Model\Person');
              $person->setContactId($data[0]);
            }
            $person->setFirstName($data[1]);
            $person->setLastName($data[2]);
            $person->setTitle($data[3]);
            $person->setJobTitle($data[4]);
            $department = $this->departmentRepository->findOneByTitle($data[5]);
            if ($department instanceof \Smply\SgContact\Domain\Model\Department){
              $person->setDepartment($department);
            }

            $person->setPhone($data[6]);
            $person->setFax($data[7]);
            $person->setEmail($data[8]);
            // Categories
            $person->removeAllCategories();
            $categoryTitles = explode(',',$data[9]);
            foreach ($categoryTitles as $categoryTitle){
              $category = $this->categoryRepository->findOneByTitle($categoryTitle);
              if ($category instanceof \Smply\SgContact\Domain\Model\Category){
                $person->addCategory($category);
              }
            }

            $this->personRepository->add($person);
          }
        }
        $this->view->assign('success', true);
      }
    }

  }

  public function importSectorsAction(){
    /**
     * @var $sector \Smply\SgContact\Domain\Model\Sector
     * @var $role \Smply\SgContact\Domain\Model\Role
     * @var $responsibility \Smply\SgContact\Domain\Model\Responsibility
     */
    if($this->request->hasArgument('submit')){
      if ($this->request->hasArgument('sectors') && $this->request->getArgument('sectors')['error'] == 0){
        // Truncate Sectors & Responsibilities
        $this->sectorRepository->removeAll();
        $this->responsibilityRepository->removeAll();
        $this->persistenceManager->persistAll();

        $sectorsFile = $this->request->getArgument('sectors');
        $sectorsFilename = uniqid('sectors');
        move_uploaded_file($sectorsFile['tmp_name'], PATH_site.'typo3temp/'.$sectorsFilename.'.csv');

        // Import or Update Categories
        if (($handle = fopen(PATH_site.'typo3temp/'.$sectorsFilename.'.csv', "r")) !== FALSE) {
          $allRoles = $this->roleRepository->findAll();
          while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
            $sector = $this->objectManager->get('Smply\SgContact\Domain\Model\Sector');
            $sector->setZip($data[0]);
            $sector->setCity($data[1]);
            $sector->setStreet($data[2]);
            $sector->setHousenumber($data[3]);

            foreach ($allRoles as $role){
              if (isset($data[intval($role->getImportColumn())]) && $data[intval($role->getImportColumn())] != ''){
                $contactId = $data[intval($role->getImportColumn())];
                $person = $this->personRepository->findOneByContactId($contactId);
                if ($person instanceof \Smply\SgContact\Domain\Model\Person){
                  $responsibility = $this->responsibilityRepository->findOneByRoleAndPerson($role, $person);
                  if (!$responsibility instanceof \Smply\SgContact\Domain\Model\Responsibility){
                    $responsibility = $this->objectManager->get('Smply\SgContact\Domain\Model\Responsibility');
                    $responsibility->setPerson($person);
                    $responsibility->setRole($role);
                    $this->responsibilityRepository->add($responsibility);
                    $this->persistenceManager->persistAll();
                  }
                  $sector->addResponsibility($responsibility);
                }
              }
            }

            $this->sectorRepository->add($sector);
          }
        }
        $this->view->assign('success', true);
      }
    }
  }
}