<?php

namespace Smply\SgContact\Util;

class AddFields implements \TYPO3\CMS\Core\SingletonInterface{

  /**
   * @var \TYPO3\CMS\Extbase\Object\ObjectManager
   */
  protected $objectManager;

  public function __construct(){
    $pluginConfiguration = array(
      'extensionName' => 'sgcontact',
      'pluginName' => 'Pi1'
    );

    $bootstrap = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Core\Bootstrap');
    $bootstrap->initialize($pluginConfiguration);

    $this->objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');

  }

  /**
   * Returns all activated Categories for use in Flexform
   *
   * @param $config
   * @return mixed
   */
  public function addCategories($config){
    /**
     * @var $category \Smply\SgContact\Domain\Model\Category
     * @var $categoryRepository \Smply\SgContact\Domain\Repository\CategoryRepository
     */
    $categoryRepository = $this->objectManager->get('Smply\SgContact\Domain\Repository\CategoryRepository');
    $optionList = array();

    foreach($categoryRepository->findAll() as $category){
      $optionList[] = array(
        0 => $category->getTitle(),
        1 => $category->getUid()
      );
    }
    $config['items'] = array_merge($config['items'],$optionList);
    return $config;
  }

  /**
   * Returns all activated Departments for use in Flexform
   *
   * @param $config
   * @return mixed
   */
  public function addDepartments($config){
    /**
     * @var $department \Smply\SgContact\Domain\Model\Department
     * @var $departmentRepository \Smply\SgContact\Domain\Repository\DepartmentRepository
     */
    $departmentRepository = $this->objectManager->get('Smply\SgContact\Domain\Repository\DepartmentRepository');
    $optionList = array();

    foreach($departmentRepository->findAll() as $department){
      $optionList[] = array(
        0 => $department->getTitle(),
        1 => $department->getUid()
      );
    }
    $config['items'] = array_merge($config['items'],$optionList);
    return $config;
  }

  /**
   * Returns all activated Persons for use in Flexform
   *
   * @param $config
   * @return mixed
   */
  public function addPersons($config){
    /**
     * @var $person \Smply\SgContact\Domain\Model\Person
     * @var $personRepository \Smply\SgContact\Domain\Repository\PersonRepository
     */
    $personRepository = $this->objectManager->get('Smply\SgContact\Domain\Repository\PersonRepository');
    $optionList = array();

    foreach($personRepository->findAll() as $person){
      $optionList[] = array(
        0 => $person->getLastName(). ', '. $person->getFirstName() . ' (' . $person->getContactId() . ')',
        1 => $person->getUid()
      );
    }
    $config['items'] = array_merge($config['items'],$optionList);
    return $config;
  }

  /**
   * Adds Template Layouts from PageTS to Flexform of Single Plugin
   *
   * @param $config
   * @return mixed
   */
  public function addSingleTemplateLayouts($config){
    $pagesTsConfig = \TYPO3\CMS\Backend\Utility\BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);
    if (isset($pagesTsConfig['tx_sgcontact.']['layouts.']['single.']) && is_array($pagesTsConfig['tx_sgcontact.']['layouts.']['single.'])) {
      $templateLayouts = $pagesTsConfig['tx_sgcontact.']['layouts.']['single.'];
    }else{
      $templateLayouts = array();
      $optionList = array();
    }
    foreach($templateLayouts as $key => $value){
      $optionList[] = array(
        0 => $value,
        1 => $key
      );
    }
    $config['items'] = array_merge($config['items'],$optionList);


    return $config;
  }


  /**
   * Adds Template Layouts from PageTS to Flexform of Category Plugin
   *
   * @param $config
   * @return mixed
   */
  public function addCategoryTemplateLayouts($config){
    $pagesTsConfig = \TYPO3\CMS\Backend\Utility\BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);
    if (isset($pagesTsConfig['tx_sgcontact.']['layouts.']['category.']) && is_array($pagesTsConfig['tx_sgcontact.']['layouts.']['category.'])) {
      $templateLayouts = $pagesTsConfig['tx_sgcontact.']['layouts.']['category.'];
    }else{
      $templateLayouts = array();
      $optionList = array();
    }
    foreach($templateLayouts as $key => $value){
      $optionList[] = array(
        0 => $value,
        1 => $key
      );
    }
    $config['items'] = array_merge($config['items'],$optionList);


    return $config;
  }

  /**
   * Adds Template Layouts from PageTS to Flexform of Multi Plugin
   *
   * @param $config
   * @return mixed
   */
  public function addMultiTemplateLayouts($config){
    $pagesTsConfig = \TYPO3\CMS\Backend\Utility\BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);
    if (isset($pagesTsConfig['tx_sgcontact.']['layouts.']['multi.']) && is_array($pagesTsConfig['tx_sgcontact.']['layouts.']['multi.'])) {
      $templateLayouts = $pagesTsConfig['tx_sgcontact.']['layouts.']['multi.'];
    }else{
      $templateLayouts = array();
      $optionList = array();
    }
    foreach($templateLayouts as $key => $value){
      $optionList[] = array(
        0 => $value,
        1 => $key
      );
    }
    $config['items'] = array_merge($config['items'],$optionList);


    return $config;
  }


}