<?php
namespace Smply\SgContact\Domain\Model;

  /***************************************************************
   *
   *  Copyright notice
   *
   *  (c) 2016 Daniel Hoffmann <hoffmann@smply.gd>, smply.gd GmbH
   *           Marc Saleiko <saleiko@smply.gd>, smply.gd GmbH
   *
   *  All rights reserved
   *
   *  This script is part of the TYPO3 project. The TYPO3 project is
   *  free software; you can redistribute it and/or modify
   *  it under the terms of the GNU General Public License as published by
   *  the Free Software Foundation; either version 3 of the License, or
   *  (at your option) any later version.
   *
   *  The GNU General Public License can be found at
   *  http://www.gnu.org/copyleft/gpl.html.
   *
   *  This script is distributed in the hope that it will be useful,
   *  but WITHOUT ANY WARRANTY; without even the implied warranty of
   *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   *  GNU General Public License for more details.
   *
   *  This copyright notice MUST APPEAR in all copies of the script!
   ***************************************************************/
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * Sector
 */
class Sector extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

  /**
   * street
   *
   * @var string
   */
  protected $street = '';


  /**
   * housenumber
   *
   * @var string
   */
  protected $housenumber = '';

  /**
   * city
   *
   * @var string
   */
  protected $city = '';

  /**
   * zip
   *
   * @var string
   */
  protected $zip = '';

  /**
   * responsibilities
   *
   * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Smply\SgContact\Domain\Model\Responsibility>
   */
  protected $responsibilities = null;

  /**
   * __construct
   */
  public function __construct()
  {
    //Do not remove the next line: It would break the functionality
    $this->initStorageObjects();
  }

  /**
   * Initializes all ObjectStorage properties
   * Do not modify this method!
   * It will be rewritten on each save in the extension builder
   * You may modify the constructor of this class instead
   *
   * @return void
   */
  protected function initStorageObjects()
  {
    $this->responsibilities = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
  }

  /**
   * @return string
   */
  public function getStreet()
  {
    /**
     * @var $temp \Smply\SgContact\Domain\Model\Category
     */

    return $this->street;
  }

  /**
   * @param string $street
   * @return $this
   */
  public function setStreet($street)
  {
    $this->street = $street;
    return $this;
  }

  /**
   * @return string
   */
  public function getHousenumber()
  {
    return $this->housenumber;
  }

  /**
   * @param string $housenumber
   * @return $this
   */
  public function setHousenumber($housenumber)
  {
    $this->housenumber = $housenumber;
    return $this;
  }

  /**
   * @return string
   */
  public function getCity()
  {
    return $this->city;
  }

  /**
   * @param string $city
   * @return $this
   */
  public function setCity($city)
  {
    $this->city = $city;
    return $this;
  }

  /**
   * @return string
   */
  public function getZip()
  {
    return $this->zip;
  }

  /**
   * @param string $zip
   * @return $this
   */
  public function setZip($zip)
  {
    $this->zip = $zip;
    return $this;
  }


  /**
   * Adds a Responsibility
   *
   * @param \Smply\SgContact\Domain\Model\Responsibility $responsibility
   * @return void
   */
  public function addResponsibility(\Smply\SgContact\Domain\Model\Responsibility $responsibility)
  {
    $this->responsibilities->attach($responsibility);
  }

  /**
   * Removes a Responsibility
   *
   * @param \Smply\SgContact\Domain\Model\Responsibility $responsibilityToRemove The Responsibility to be removed
   * @return void
   */
  public function removeResponsibility(\Smply\SgContact\Domain\Model\Responsibility $responsibilityToRemove)
  {
    $this->responsibilities->detach($responsibilityToRemove);
  }

  /**
   * Returns the Responsibilities
   *
   * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Smply\SgContact\Domain\Model\Responsibility> $responsibilities
   */
  public function getResponsibilities()
  {
    return $this->responsibilities;
  }

  /**
   * Sets the Responsibilities
   *
   * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Smply\SgContact\Domain\Model\Responsibility> $responsibilities
   * @return void
   */
  public function setResponsibilities(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $responsibilities)
  {
    $this->responsibilities = $responsibilities;
  }



}