<?php
declare(strict_types = 1);


namespace SG\BlogSgEnhancements\Domain\Repository;


use T3G\AgencyPack\Blog\Constants;
use T3G\AgencyPack\Blog\Domain\Model\Category;
use T3G\AgencyPack\Blog\Domain\Model\Post;
use TYPO3\CMS\Extbase\Persistence\Generic\Qom\ComparisonInterface;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;

class PostRepository extends \T3G\AgencyPack\Blog\Domain\Repository\PostRepository
{

    /**
     * This method is overridden because we need to set the objectType
     * to the original Post model
     *
     * @inheritDoc
     * @throws \Exception
     */
    public function initializeObject(): void
    {
        $querySettings = $this->objectManager->get(Typo3QuerySettings::class);
        // don't add the pid constraint
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);

        // Set the object type to the original Post model
        // because createQuery would otherwise try to find
        // a Post model in this extension
        $this->objectType = Post::class;

        $query = $this->createQuery();

        $this->defaultConstraints[] = $query->equals('doktype', Constants::DOKTYPE_BLOG_POST);
        $this->defaultOrderings = [
            'publish_date' => QueryInterface::ORDER_DESCENDING,
        ];
    }

    /**
     * @param Category $category
     * @param int      $limit
     *
     * @return array|\TYPO3\CMS\Extbase\Persistence\QueryResultInterface
     * @throws \TYPO3\CMS\Extbase\Configuration\Exception\InvalidConfigurationTypeException
     * @throws \TYPO3\CMS\Extbase\Persistence\Exception\InvalidQueryException
     */
    public function findAllByCategoryWithLimit(Category $category, int $limit = 1)
    {
        return $this->findAllByCategoryWithLimitAndOffset($category, $limit, 0);
    }

    /**
     * @param Category $category
     * @param int      $limit
     * @param int      $offset
     *
     * @return array|\TYPO3\CMS\Extbase\Persistence\QueryResultInterface
     * @throws \TYPO3\CMS\Extbase\Configuration\Exception\InvalidConfigurationTypeException
     * @throws \TYPO3\CMS\Extbase\Persistence\Exception\InvalidQueryException
     */
    public function findAllByCategoryWithLimitAndOffset(Category $category, int $limit = 0, int $offset = 0)
    {
        $query = $this->createQuery();
        $constraints = $this->defaultConstraints;
        $constraints[] = $query->contains('categories', $category);
        $storagePidConstraint = $this->getStoragePidConstraint();
        if ($storagePidConstraint instanceof ComparisonInterface) {
            $constraints[] = $storagePidConstraint;
        }
        if( $limit > 0 ) {
            $query->setLimit($limit);
        }
        if( $offset > 0 ) {
            $query->setOffset($offset);
        }

        return $query->matching($query->logicalAnd($constraints))->execute();
    }

    /**
     * @param int $limit
     * @param int $offset
     *
     * @return array|\TYPO3\CMS\Extbase\Persistence\QueryResultInterface
     * @throws \TYPO3\CMS\Core\Context\Exception\AspectNotFoundException
     * @throws \TYPO3\CMS\Extbase\Configuration\Exception\InvalidConfigurationTypeException
     * @throws \TYPO3\CMS\Extbase\Persistence\Exception\InvalidQueryException
     */
    public function findAllWithLimitAndOffset(int $limit, int $offset)
    {
        $query = $this->getFindAllQuery();
        $query->setLimit($limit);
        $query->setOffset($offset);

        return $query->execute();
    }

}
