# Blog Enhancements
This extension adds useful plugins and functionality to t3g/blog extension.

## Plugins
This extension provides four additional plugins that enrich
the overall comfort and configurability of the t3g/blog extension:
- **Blog: Featured Post:** Fetch the newest post. Returns only one post. You
may select a category to only fetch the newest post of the provided category.
- **Blog: List Posts:** Normal list posts plugin that provides a limit and
offset selection per plugin. You can also use a category to filter the 
selection.
- **Blog: Curated Posts:** Use the provided side-by-side select to add
only those posts you want to display in this plugin.
- **Blog: List Categories:** List the selected categories (not all).

## Add new template layouts to plugins
You have the option to **select a certain template layout for each of the
provided plugins**. The default is the "Standard" layout. You may add your own 
layout choices per plugin by adding some additional configuration to your
pageTS:

```
tx_blogsgenhancements.layouts.featuredPost {
    # "test" is the value and "Test" the label
    test = Test
}
```

Use these identifiers after `layouts.` to define additional layouts for
all plugins:
- `listPosts`
- `curatedPosts`
- `featuredPost`
- `listCategories`

## Inline display of blog plugins in page layout
If you do not wish to use the default page template provided by 
the blog extension and you want to use your own page templates you may
use one of these inline plugin renderers to help you with
the display of certain blog plugins in your page layout:

```
# Displays the comment form
<f:cObject typoscriptObjectPath="lib.blogsgenhancements.commentForm"></f:cObject>
# Displays the submitted comments
<f:cObject typoscriptObjectPath="lib.blogsgenhancements.comments"></f:cObject>
# Display the related posts
<f:cObject typoscriptObjectPath="lib.blogsgenhancements.relatedPosts"></f:cObject>
```
