<?php


namespace SG\BlogSgEnhancements\Util;


use SG\BlogSgEnhancements\Domain\Repository\PostRepository;
use T3G\AgencyPack\Blog\Domain\Model\Post;
use TYPO3\CMS\Backend\Utility\BackendUtility;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Extbase\Object\ObjectManagerInterface;

class AddFields implements SingletonInterface
{

    /** @var ObjectManagerInterface  */
    private $objectManager;

    /** @var PostRepository */
    private $postRepository;

    public function __construct(){

        $pluginConfiguration = array(
            'vendorName' => 'SG',
            'extensionName' => 'blogsgenhancements',
            'pluginName' => 'blogcuratedposts',
        );

        $bootstrap = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Core\Bootstrap');
        $bootstrap->initialize($pluginConfiguration);

        $this->objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');
        $this->postRepository = $this->objectManager->get(PostRepository::class);

    }

    /**
     * @param $config
     *
     * @return mixed
     * @throws \TYPO3\CMS\Extbase\Configuration\Exception\InvalidConfigurationTypeException
     * @throws \TYPO3\CMS\Extbase\Persistence\Exception\InvalidQueryException
     */
    public function addPosts($config)
    {
        $options = [];
        /** @var Post $post */
        foreach ($this->postRepository->findAllByPid() as $post) {
            $options[] = [
                0 => $post->getTitle(),
                1 => $post->getUid(),
            ];
        }
        $config[ 'items' ] = array_merge($config[ 'items' ], $options);
        return $config;
    }

    /**
     * @param $config
     * @return mixed
     */
    public function addListPostsTemplateLayouts($config){
        $optionList = $this->getTemplateLayoutOptionList($config, 'listPosts');
        $config['items'] = array_merge($config['items'],$optionList);

        return $config;
    }

    /**
     * @param $config
     * @return mixed
     */
    public function addCuratedPostsTemplateLayouts($config){
        $optionList = $this->getTemplateLayoutOptionList($config, 'curatedPosts');
        $config['items'] = array_merge($config['items'],$optionList);

        return $config;
    }

    /**
     * @param $config
     * @return mixed
     */
    public function addFeaturedPostTemplateLayouts($config){
        $optionList = $this->getTemplateLayoutOptionList($config, 'featuredPost');
        $config['items'] = array_merge($config['items'],$optionList);

        return $config;
    }

    /**
     * @param $config
     * @return mixed
     */
    public function addListCategoriesTemplateLayouts($config){
        $optionList = $this->getTemplateLayoutOptionList($config, 'listCategories');
        $config['items'] = array_merge($config['items'],$optionList);

        return $config;
    }

    /**
     * @param        $config
     * @param string $pageTsIdentifier
     *
     * @return array
     */
    private function getTemplateLayoutOptionList($config, $pageTsIdentifier = '')
    {
        $optionList = [];
        $templateLayouts = [];
        if( $pageTsIdentifier !== '' ) {
            $pagesTsConfig = BackendUtility::getPagesTSconfig($config['flexParentDatabaseRow']['pid']);
            if (isset($pagesTsConfig['tx_blogsgenhancements.']['layouts.'][$pageTsIdentifier.'.']) && is_array($pagesTsConfig['tx_blogsgenhancements.']['layouts.'][$pageTsIdentifier.'.'])) {
                $templateLayouts = $pagesTsConfig['tx_blogsgenhancements.']['layouts.'][$pageTsIdentifier.'.'];
            }
            foreach($templateLayouts as $key => $value){
                $optionList[] = array(
                    0 => $value,
                    1 => $key
                );
            }
        }
        return $optionList;
    }

}