<?php

/*
 * This file is part of the package t3g/blog.
 *
 * For the full copyright and license information, please read the
 * LICENSE file that was distributed with this source code.
 */

if (!defined('TYPO3_MODE')) {
    die('Access denied.');
}

$GLOBALS['TCA']['pages']['columns'] = array_replace_recursive(
    $GLOBALS['TCA']['pages']['columns'],
    [
        'blog_sg_enhancements_detail_image' => [
            'label' => 'Blog Detail Image',
            'config' => \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::getFileFieldTCAConfig(
                'blog_sg_enhancements_detail_image',
                [
                    'minitems' => 0,
                    'maxitems' => 1,
                    'behaviour' => [
                        'allowLanguageSynchronization' => true
                    ],
                    'overrideChildTca' => array(
                        'types' => array(
                            '0' => array(
                                'showitem' => '
                            --palette--;
                                LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;
                                imageoverlayPalette,
                            --palette--;;filePalette'
                            ),
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_TEXT => array(
                                'showitem' => '
                            --palette--;
                                LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;
                                imageoverlayPalette,
                            --palette--;;filePalette'
                            ),
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_IMAGE => array(
                                'showitem' => '
                            --palette--;
                                LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;
                                imageoverlayPalette,
                            --palette--;;filePalette'
                            ),
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_AUDIO => array(
                                'showitem' => '
                            --palette--;
                                LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;
                                imageoverlayPalette,
                            --palette--;;filePalette'
                            ),
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_VIDEO => array(
                                'showitem' => '
                            --palette--;
                                LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;
                                imageoverlayPalette,
                            --palette--;;filePalette'
                            ),
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_APPLICATION => array(
                                'showitem' => '
                            --palette--;
                                LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;
                                imageoverlayPalette,
                            --palette--;;filePalette'
                            )
                        )
                    ),
                ],
                'jpg,png'
            ),
        ],
    ]
);
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addToAllTCAtypes(
    'pages',
    '--div--;Blog Enhancement,blog_sg_enhancements_detail_image',
    (string) \T3G\AgencyPack\Blog\Constants::DOKTYPE_BLOG_POST
);