<?php


namespace SG\BlogSgEnhancements\Util;


use SG\BlogSgEnhancements\Domain\Repository\PostRepository;
use T3G\AgencyPack\Blog\Domain\Model\Post;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Extbase\Object\ObjectManagerInterface;

class AddFields implements SingletonInterface
{

    /** @var ObjectManagerInterface  */
    private $objectManager;

    /** @var PostRepository */
    private $postRepository;

    public function __construct(){

        $pluginConfiguration = array(
            'vendorName' => 'SG',
            'extensionName' => 'blogsgenhancements',
            'pluginName' => 'blogcuratedposts'
        );

        $bootstrap = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Core\Bootstrap');
        $bootstrap->initialize($pluginConfiguration);

        $this->objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');
        $this->postRepository = $this->objectManager->get(PostRepository::class);

    }

    /**
     * @param $config
     *
     * @return mixed
     * @throws \TYPO3\CMS\Extbase\Configuration\Exception\InvalidConfigurationTypeException
     * @throws \TYPO3\CMS\Extbase\Persistence\Exception\InvalidQueryException
     */
    public function addPosts($config)
    {
        $options = [];
        /** @var Post $post */
        foreach ($this->postRepository->findAllByPid() as $post) {
            $options[] = [
                0 => $post->getTitle(),
                1 => $post->getUid(),
            ];
        }
        $config[ 'items' ] = array_merge($config[ 'items' ], $options);
        return $config;
    }

}