<?php

namespace Smply\SgEstateStatistics\Tasks;

use TYPO3\CMS\Scheduler\Task\AbstractTask;

class Calculate extends AbstractTask
{
    /**
     * @var \TYPO3\CMS\Extbase\Object\ObjectManager
     * @inject
     */
    private $objectManager;

    /**
     * @var \TYPO3\CMS\Core\Database\DatabaseConnection
     */
    protected $database;

    /**
     * @var array
     */
    private $errors = array();

    /**
     * Initializes Objectmanager and Database Connection
     */
    public function initialize()
    {
        $this->database = $GLOBALS['TYPO3_DB'];
        $this->objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');
    }

    /**
     * Executes the Statistic Task
     * Counting & Generation of Transferfile
     *
     * @return bool
     */
    public function execute()
    {
        $this->initialize();

        if (!$this->isDataForNowInDatabase()) {
            $statisticArray = array(
                'ZIMMER'                       => array(
                    'KAUF'        => 0,
                    'MIETE_PACHT' => 0,
                    'ERBPACHT'    => 0,
                    'LEASING'     => 0
                ),
                'WOHNUNG'                      => array(
                    'KAUF'        => 0,
                    'MIETE_PACHT' => 0,
                    'ERBPACHT'    => 0,
                    'LEASING'     => 0
                ),
                'HAUS'                         => array(
                    'KAUF'        => 0,
                    'MIETE_PACHT' => 0,
                    'ERBPACHT'    => 0,
                    'LEASING'     => 0
                ),
                'GRUNDSTUECK'                  => array(
                    'KAUF'        => 0,
                    'MIETE_PACHT' => 0,
                    'ERBPACHT'    => 0,
                    'LEASING'     => 0
                ),
                'BUERO_PRAXEN'                 => array(
                    'KAUF'        => 0,
                    'MIETE_PACHT' => 0,
                    'ERBPACHT'    => 0,
                    'LEASING'     => 0
                ),
                'EINZELHANDEL'                 => array(
                    'KAUF'        => 0,
                    'MIETE_PACHT' => 0,
                    'ERBPACHT'    => 0,
                    'LEASING'     => 0
                ),
                'GASTGEWERBE'                  => array(
                    'KAUF'        => 0,
                    'MIETE_PACHT' => 0,
                    'ERBPACHT'    => 0,
                    'LEASING'     => 0
                ),
                'HALLEN_LAGER_PROD'            => array(
                    'KAUF'        => 0,
                    'MIETE_PACHT' => 0,
                    'ERBPACHT'    => 0,
                    'LEASING'     => 0
                ),
                'LAND_UND_FORSTWIRTSCHAFT'     => array(
                    'KAUF'        => 0,
                    'MIETE_PACHT' => 0,
                    'ERBPACHT'    => 0,
                    'LEASING'     => 0
                ),
                'PARKEN'                       => array(
                    'KAUF'        => 0,
                    'MIETE_PACHT' => 0,
                    'ERBPACHT'    => 0,
                    'LEASING'     => 0
                ),
                'SONSTIGE'                     => array(
                    'KAUF'        => 0,
                    'MIETE_PACHT' => 0,
                    'ERBPACHT'    => 0,
                    'LEASING'     => 0
                ),
                'FREIZEITIMMOBILIE_GEWERBLICH' => array(
                    'KAUF'        => 0,
                    'MIETE_PACHT' => 0,
                    'ERBPACHT'    => 0,
                    'LEASING'     => 0
                ),
                'ZINSHAUS_RENDITEOBJEKT'       => array(
                    'KAUF'        => 0,
                    'MIETE_PACHT' => 0,
                    'ERBPACHT'    => 0,
                    'LEASING'     => 0
                )
            );

            $resultObject = $this->database->sql_query('SELECT count(tx_t3immobilien_domain_model_immobilie.uid) as anzahl, tx_t3immobilien_domain_model_objektart.kuerzel as objektart, tx_t3immobilien_domain_model_vermarktungsart.kuerzel as vermarktungsart
FROM tx_t3immobilien_domain_model_immobilie
LEFT JOIN (SELECT * FROM tx_t3immobilien_immobilie_vermarktungsart_mm GROUP BY uid_local) temp_t3immobilien_immobilie_vermarktungsart_mm ON tx_t3immobilien_domain_model_immobilie.uid = temp_t3immobilien_immobilie_vermarktungsart_mm.uid_local
LEFT JOIN tx_t3immobilien_domain_model_vermarktungsart ON temp_t3immobilien_immobilie_vermarktungsart_mm.uid_foreign = tx_t3immobilien_domain_model_vermarktungsart.uid
LEFT JOIN tx_t3immobilien_domain_model_objektart ON tx_t3immobilien_domain_model_immobilie.objektart = tx_t3immobilien_domain_model_objektart.uid
GROUP BY tx_t3immobilien_domain_model_immobilie.objektart, tx_t3immobilien_domain_model_vermarktungsart.kuerzel;');

            while ($result = $this->database->sql_fetch_assoc($resultObject)) {
                $statisticArray[$result['objektart']][$result['vermarktungsart']] = $result['anzahl'];
            }

            $jsonStatisticArray = json_encode($statisticArray);

            $this->database->exec_INSERTquery(
                'tx_sgestatestatistics_data', // Table
                array(
                    'tstamp'         => time(),
                    'statistic_data' => $jsonStatisticArray
                )
            );
        }

        $this->generateTransferFile();

        if (count($this->errors) > 0){
            throw new \RuntimeException(implode(', ', $this->errors), 1313131313);
        }else{
            return true;
        }
    }

    /**
     * Checks if Data for Today is already collected
     *
     * @return bool
     */
    private function isDataForNowInDatabase()
    {
        $resultObject = $this->database->sql_query('SELECT tstamp FROM tx_sgestatestatistics_data WHERE DATE_FORMAT(FROM_UNIXTIME(tstamp), "%d.%m.%Y") = DATE_FORMAT(NOW(), "%d.%m.%Y")');
        if ($this->database->sql_num_rows($resultObject) == 0) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * Generate the File for s.g. Analytics
     */
    private function generateTransferFile()
    {
        $extensionConfiguration = unserialize($GLOBALS['TYPO3_CONF_VARS']['EXT']['extConf']['sg_estate_statistics']);
        $result = $this->database->exec_SELECTgetRows('*', 'tx_sgestatestatistics_data', '', '', 'tstamp DESC', '30');
        $fileContent = array();
        foreach ($result as $item) {
            $fileContent[$item['tstamp']] = json_decode($item['statistic_data']);
        }
        $fileHandle = @fopen(PATH_site . "typo3temp/sg_estate_statistics.json", "w+");
        if ($fileHandle){
            if ($extensionConfiguration['activateEncryption']) {
                fwrite($fileHandle, openssl_encrypt(json_encode($fileContent), "AES-128-ECB", $extensionConfiguration['encryptionPassword']));
            } else {
                fwrite($fileHandle, json_encode($fileContent));
            }
            fclose($fileHandle);
        }else{
            array_push($this->errors, 'Transferfile could not be opened / created.');
        }
    }
}