<?php

namespace Daho\SgEstateCompare\Controller;

class CompareController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController {

  /**
   * @var \Daho\SgEstateCore\Domain\Repository\ImmobilieRepository
   * @inject
   */
  protected $immobilienRepository;

  /**
   * Actions Show Comparison Page
   */
  public function showAction(){
    $compareRealties = array();
    $compareItems = $GLOBALS['TSFE']->fe_user->getKey('ses', 'sg-compare-items');
    if (is_array($compareItems)){
      foreach ($compareItems as $item){
        $tempRealty = $this->immobilienRepository->findOneByObjektnrIntern($item);
        if ($tempRealty instanceof \Daho\SgEstateCore\Domain\Model\Immobilie){
          array_push($compareRealties, $tempRealty);
        }
      }
    }
    $this->view->assign('compareRealties', $compareRealties);
  }

  /**
   * Processes all Requests for Compare Extension
   * Add, Remove, Status
   *
   * @return string
   */
  public function ajaxAction(){
    $allowedFunctions = array('add','remove','status','isOnList');
    $return = array();
    if ($this->request->hasArgument('function') && in_array($this->request->getArgument('function'), $allowedFunctions)){

      $activeFunction = $this->request->getArgument('function');
      switch ($activeFunction){
        case 'add':
          // Add Action (Return: Status, Count of Realties in Session, Max Count of Relaties in Session)
          if ($this->request->hasArgument('realty') && $this->request->getArgument('realty') != ''){
            $realty = $this->immobilienRepository->findOneByObjektnrIntern($this->request->getArgument('realty'));
            if ($realty instanceof \Daho\SgEstateCore\Domain\Model\Immobilie){
              $compareItems = is_array($GLOBALS['TSFE']->fe_user->getKey('ses', 'sg-compare-items')) ? $GLOBALS['TSFE']->fe_user->getKey('ses', 'sg-compare-items') : array();
              if (count($compareItems) < $this->settings['maxAmount']){
                if (!in_array($realty->getObjektnrIntern(), $compareItems)){
                  array_push($compareItems, $realty->getObjektnrIntern());
                  $GLOBALS['TSFE']->fe_user->setKey('ses', 'sg-compare-items', $compareItems);
                  $return = array(
                    'success' => true,
                    'amount' => count($compareItems),
                    'maxAmount' => $this->settings['maxAmount']
                  );
                }else{
                  $return = array(
                    'success' => false,
                    'error' => 'ALWAYS_ON_LIST'
                  );
                }
              }else{
                $return = array(
                  'success' => false,
                  'error' => 'TOO_MANY'
                );
              }
            }else{
              $return = array(
                'success' => false,
                'error' => 'BAD_REQUEST'
              );
            }
          }else{
            $return = array(
              'success' => false,
              'error' => 'BAD_REQUEST'
            );
          }
          break;
        case 'remove':
          // Remove Action (Return: Status, Count of Realties in Session, Max Count of Relaties in Session)
          if ($this->request->hasArgument('realty') && $this->request->getArgument('realty') != ''){
            $realty = $this->immobilienRepository->findOneByObjektnrIntern($this->request->getArgument('realty'));
            if ($realty instanceof \Daho\SgEstateCore\Domain\Model\Immobilie){
              $compareItems = is_array($GLOBALS['TSFE']->fe_user->getKey('ses', 'sg-compare-items')) ? $GLOBALS['TSFE']->fe_user->getKey('ses', 'sg-compare-items') : array();
              if (in_array($realty->getObjektnrIntern(), $compareItems)){
                unset($compareItems[array_search($realty->getObjektnrIntern(),$compareItems)]);
                $GLOBALS['TSFE']->fe_user->setKey('ses', 'sg-compare-items', $compareItems);
                $return = array(
                  'success' => true,
                  'amount' => count($compareItems),
                  'maxAmount' => $this->settings['maxAmount']
                );
              }else{
                $return = array(
                  'success' => false,
                  'error' => 'BAD_REQUEST'
                );
              }
            }else{
              $return = array(
                'success' => false,
                'error' => 'BAD_REQUEST'
              );
            }
          }else{
            $return = array(
              'success' => false,
              'error' => 'BAD_REQUEST'
            );
          }
          break;
        case 'status':
          $compareItems = $GLOBALS['TSFE']->fe_user->getKey('ses', 'sg-compare-items');
          $return = array(
            'success' => true,
            'amount' => count($compareItems),
            'maxAmount' => $this->settings['maxAmount']
          );
          break;
        case 'isOnList':
          if ($this->request->hasArgument('realty') && $this->request->getArgument('realty') != ''){
            $realty = $this->immobilienRepository->findOneByObjektnrIntern($this->request->getArgument('realty'));
            if ($realty instanceof \Daho\SgEstateCore\Domain\Model\Immobilie){
              $compareItems = is_array($GLOBALS['TSFE']->fe_user->getKey('ses', 'sg-compare-items')) ? $GLOBALS['TSFE']->fe_user->getKey('ses', 'sg-compare-items') : array();
              if (in_array($realty->getObjektnrIntern(), $compareItems)){
                $return = array(
                  'success' => true,
                  'onlist' => true,
                );
              }else{
                $return = array(
                  'success' => true,
                  'onlist' => false,
                );
              }
            }else{
              $return = array(
                'success' => false,
                'error' => 'BAD_REQUEST'
              );
            }
          }else{
            $return = array(
              'success' => false,
              'error' => 'BAD_REQUEST'
            );
          }
          break;
      }
    }
    else{
      $return = array(
        'success' => false
      );
    }
    return json_encode($return);

  }
}