<?php
defined('TYPO3_MODE') || die();

(static function() {
    \TYPO3\CMS\Extbase\Utility\ExtensionUtility::configurePlugin(
        'Sgemployee',
        'Partner',
        [
            \Sg\Sgemployee\Controller\PartnerController::class => 'search'
        ],
        // non-cacheable actions
        [
            \Sg\Sgemployee\Controller\PartnerController::class => 'search'
        ]
    );

    // wizards
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPageTSConfig(
        'mod {
            wizards.newContentElement.wizardItems.plugins {
                elements {
                    partner {
                        iconIdentifier = sgemployee-plugin-partner
                        title = LLL:EXT:sgemployee/Resources/Private/Language/locallang_db.xlf:tx_sgemployee_partner.name
                        description = LLL:EXT:sgemployee/Resources/Private/Language/locallang_db.xlf:tx_sgemployee_partner.description
                        tt_content_defValues {
                            CType = list
                            list_type = sgemployee_partner
                        }
                    }
                }
                show = *
            }
       }'
    );

    $iconRegistry = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\TYPO3\CMS\Core\Imaging\IconRegistry::class);
    $iconRegistry->registerIcon(
        'sgemployee-plugin-partner',
        \TYPO3\CMS\Core\Imaging\IconProvider\SvgIconProvider::class,
        ['source' => 'EXT:sgemployee/Resources/Public/Icons/user_plugin_partner.svg']
    );
})();
