<?php

declare(strict_types=1);

namespace Sg\Sgemployee\Tests\Unit\Controller;

use PHPUnit\Framework\MockObject\MockObject;
use TYPO3\CMS\Extbase\Mvc\View\ViewInterface;
use TYPO3\TestingFramework\Core\AccessibleObjectInterface;
use TYPO3\TestingFramework\Core\Unit\UnitTestCase;

/**
 * Test case
 *
 * @author A.Bogatyrev <bogatyrev@smply.gd>
 */
class PartnerControllerTest extends UnitTestCase
{
    /**
     * @var \Sg\Sgemployee\Controller\PartnerController|MockObject|AccessibleObjectInterface
     */
    protected $subject;

    protected function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->getMockBuilder($this->buildAccessibleProxy(\Sg\Sgemployee\Controller\PartnerController::class))
            ->onlyMethods(['redirect', 'forward', 'addFlashMessage'])
            ->disableOriginalConstructor()
            ->getMock();
    }

    protected function tearDown(): void
    {
        parent::tearDown();
    }

    /**
     * @test
     */
    public function listActionFetchesAllPartnersFromRepositoryAndAssignsThemToView(): void
    {
        $allPartners = $this->getMockBuilder(\TYPO3\CMS\Extbase\Persistence\ObjectStorage::class)
            ->disableOriginalConstructor()
            ->getMock();

        $partnerRepository = $this->getMockBuilder(\::class)
            ->onlyMethods(['findAll'])
            ->disableOriginalConstructor()
            ->getMock();
        $partnerRepository->expects(self::once())->method('findAll')->will(self::returnValue($allPartners));
        $this->subject->_set('partnerRepository', $partnerRepository);

        $view = $this->getMockBuilder(ViewInterface::class)->getMock();
        $view->expects(self::once())->method('assign')->with('partners', $allPartners);
        $this->subject->_set('view', $view);

        $this->subject->listAction();
    }

    /**
     * @test
     */
    public function showActionAssignsTheGivenPartnerToView(): void
    {
        $partner = new \Sg\Sgemployee\Domain\Model\Partner();

        $view = $this->getMockBuilder(ViewInterface::class)->getMock();
        $this->subject->_set('view', $view);
        $view->expects(self::once())->method('assign')->with('partner', $partner);

        $this->subject->showAction($partner);
    }

    /**
     * @test
     */
    public function createActionAddsTheGivenPartnerToPartnerRepository(): void
    {
        $partner = new \Sg\Sgemployee\Domain\Model\Partner();

        $partnerRepository = $this->getMockBuilder(\::class)
            ->onlyMethods(['add'])
            ->disableOriginalConstructor()
            ->getMock();

        $partnerRepository->expects(self::once())->method('add')->with($partner);
        $this->subject->_set('partnerRepository', $partnerRepository);

        $this->subject->createAction($partner);
    }

    /**
     * @test
     */
    public function editActionAssignsTheGivenPartnerToView(): void
    {
        $partner = new \Sg\Sgemployee\Domain\Model\Partner();

        $view = $this->getMockBuilder(ViewInterface::class)->getMock();
        $this->subject->_set('view', $view);
        $view->expects(self::once())->method('assign')->with('partner', $partner);

        $this->subject->editAction($partner);
    }

    /**
     * @test
     */
    public function updateActionUpdatesTheGivenPartnerInPartnerRepository(): void
    {
        $partner = new \Sg\Sgemployee\Domain\Model\Partner();

        $partnerRepository = $this->getMockBuilder(\::class)
            ->onlyMethods(['update'])
            ->disableOriginalConstructor()
            ->getMock();

        $partnerRepository->expects(self::once())->method('update')->with($partner);
        $this->subject->_set('partnerRepository', $partnerRepository);

        $this->subject->updateAction($partner);
    }

    /**
     * @test
     */
    public function deleteActionRemovesTheGivenPartnerFromPartnerRepository(): void
    {
        $partner = new \Sg\Sgemployee\Domain\Model\Partner();

        $partnerRepository = $this->getMockBuilder(\::class)
            ->onlyMethods(['remove'])
            ->disableOriginalConstructor()
            ->getMock();

        $partnerRepository->expects(self::once())->method('remove')->with($partner);
        $this->subject->_set('partnerRepository', $partnerRepository);

        $this->subject->deleteAction($partner);
    }
}
