<?php

declare(strict_types=1);

namespace Sg\Sgemployee\Controller;

use Sg\Sgemployee\Domain\Repository\PartnerRepository;

/**
 * This file is part of the "sg_employee" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * (c) 2023 A.Bogatyrev <bogatyrev@smply.gd>, smply.gd
 */

/**
 * PartnerController
 */
class PartnerController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{

    /**
     * partnerRepository
     *
     * @var \Sg\Sgemployee\Domain\Repository\PartnerRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    protected $partnerRepository = null;


    /**
     * action index
     *
     * @return string|object|null|void
     */
    public function indexAction()
    {
    }

    /**
     * action search
     *
     * @return string|object|null|void
     */
    public function searchAction()
    {
        $partners = $this->partnerRepository->findAll();
        $this->view->assign('partners', $partners);
    }

    /**
     * action list
     *
     * @return string|object|null|void
     */
    public function listAction()
    {
        $partners = $this->partnerRepository->findAll();
        $this->view->assign('partners', $partners);
    }

    /**
     * action show
     *
     * @param \Sg\Sgemployee\Domain\Model\Partner $partner
     * @return string|object|null|void
     */
    public function showAction(\Sg\Sgemployee\Domain\Model\Partner $partner)
    {
        $this->view->assign('partner', $partner);
    }

    /**
     * action new
     *
     * @return string|object|null|void
     */
    public function newAction()
    {
    }

    /**
     * action create
     *
     * @param \Sg\Sgemployee\Domain\Model\Partner $newPartner
     * @return string|object|null|void
     */
    public function createAction(\Sg\Sgemployee\Domain\Model\Partner $newPartner)
    {
        $this->addFlashMessage('The object was created. Please be aware that this action is publicly accessible unless you implement an access check. See https://docs.typo3.org/p/friendsoftypo3/extension-builder/master/en-us/User/Index.html', '', \TYPO3\CMS\Core\Messaging\AbstractMessage::WARNING);
        $this->partnerRepository->add($newPartner);
        $this->redirect('list');
    }

    /**
     * action edit
     *
     * @param \Sg\Sgemployee\Domain\Model\Partner $partner
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation("partner")
     * @return string|object|null|void
     */
    public function editAction(\Sg\Sgemployee\Domain\Model\Partner $partner)
    {
        $this->view->assign('partner', $partner);
    }

    /**
     * action update
     *
     * @param \Sg\Sgemployee\Domain\Model\Partner $partner
     * @return string|object|null|void
     */
    public function updateAction(\Sg\Sgemployee\Domain\Model\Partner $partner)
    {
        $this->addFlashMessage('The object was updated. Please be aware that this action is publicly accessible unless you implement an access check. See https://docs.typo3.org/p/friendsoftypo3/extension-builder/master/en-us/User/Index.html', '', \TYPO3\CMS\Core\Messaging\AbstractMessage::WARNING);
        $this->partnerRepository->update($partner);
        $this->redirect('list');
    }

    /**
     * action delete
     *
     * @param \Sg\Sgemployee\Domain\Model\Partner $partner
     * @return string|object|null|void
     */
    public function deleteAction(\Sg\Sgemployee\Domain\Model\Partner $partner)
    {
        $this->addFlashMessage('The object was deleted. Please be aware that this action is publicly accessible unless you implement an access check. See https://docs.typo3.org/p/friendsoftypo3/extension-builder/master/en-us/User/Index.html', '', \TYPO3\CMS\Core\Messaging\AbstractMessage::WARNING);
        $this->partnerRepository->remove($partner);
        $this->redirect('list');
    }
}
