<?php

namespace SG\SgRegionpages\Hooks;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Database\Query\Restriction\DeletedRestriction;
use TYPO3\CMS\Core\Database\Query\Restriction\HiddenRestriction;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;

class KesearchRegionpages 
{

    protected $indexerConfigurationKey = 'regionpagesindexer';

    public function registerIndexerConfiguration(array $params, $pObj): void
    {
        $customIndexer = [
            '[CUSTOM] Regionpages-Indexer (ext:regionpages)',
            $this->indexerConfigurationKey,
            'EXT:sg_regionpages/Resources/Public/Icons/PluginIcon.png'
        ];
        $params['items'][] = $customIndexer;
    }

    protected function getContent()
    {
		$sql = "
				`uid`, 
				`title`, 
				`parent`, 
				`childs`, 
				`headline`,
				`teaser`,
				`slug`,
				`crdate`,
				`pid`,
				`tstamp`,
				`sys_language_uid`,
				`starttime`,
				`endtime`, 
				IF(`childs` > 0, 
					(
						SELECT GROUP_CONCAT(`title` SEPARATOR ' ') 
						FROM `tx_sgregionpages_domain_model_contentcollection` 
						WHERE `parent` = `sorted`.`uid` 
						GROUP BY `parent`
					), 
					(
						SELECT 
							CASE
								WHEN `tt`.`CType` = 'text' THEN 
									CONCAT_WS(
										' ',
										GROUP_CONCAT(`tt`.`header` SEPARATOR ' '),
										GROUP_CONCAT(`tt`.`bodytext` SEPARATOR ' ')
									)
								WHEN `tt`.`CType` = 'header' THEN 
									GROUP_CONCAT(`tt`.`header` SEPARATOR ' ') 
								WHEN `tt`.`CType` = 'textmedia' THEN 
									CONCAT_WS(
										' ',
										GROUP_CONCAT(`tt`.`header` SEPARATOR ' '),
										GROUP_CONCAT(`tt`.`bodytext` SEPARATOR ' ')
									)
								WHEN `tt`.`CType` = 'textpic' THEN 
									CONCAT_WS(
										' ',
										GROUP_CONCAT(`tt`.`header` SEPARATOR ' '),
										GROUP_CONCAT(`tt`.`bodytext` SEPARATOR ' ')
									)
								ELSE ' '
							END
						 FROM `tt_content` AS `tt` 
						 INNER JOIN `sys_refindex` AS `sr` 
							ON `sr`.`tablename` = 'tx_sgregionpages_domain_model_contentcollection' 
							AND `sr`.`ref_uid` = `tt`.`uid` 
						 WHERE `tt`.`pid` = `sorted`.`pid` 
						 AND `sr`.`recuid` = `sorted`.`uid` 
						 GROUP BY `tt`.`pid` 
						 ORDER BY `tt`.`sorting`
					)
				) AS `content`,
				(
					IF(`sorted`.`parent` > 0, 
						(SELECT CONCAT(`slug`, '~', `sorted`.`slug`) FROM `tx_sgregionpages_domain_model_contentcollection` WHERE `uid` = `sorted`.`parent`),
						`sorted`.`slug`
					)
				) AS `tree` 
			FROM 
				( 
					SELECT 
						`uid`, 
						`title`, 
						`parent`, 
						(
							SELECT COUNT(`uid`) FROM `tx_sgregionpages_domain_model_contentcollection` WHERE `parent` = `t`.`uid`
						) AS `childs`, 
						`headline`,
						`teaser`,
						`slug`,
						`crdate`,
						`pid`,
						`tstamp`,
						`sys_language_uid`,
						`starttime`,
						`endtime` 
					FROM `tx_sgregionpages_domain_model_contentcollection` AS t 
					ORDER BY `parent`, `uid` 		
				) AS `sorted`, 
				( 
					SELECT @input := '0'
				) AS `init` 
			WHERE 
				FIND_IN_SET(`parent`, @input) 
			AND 
				LENGTH(@input := CONCAT(@input, ',', `uid`))
		";
		$this->connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionByName('Default');
		return  $this->connection->createQueryBuilder()->addSelectLiteral($sql)->execute()->fetchAll();
    }

    public function customIndexer($indexerConfig, $indexerObject)
    {
		
		$objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\\CMS\Extbase\\Object\\ObjectManager');
		$configurationManager = $objectManager->get('TYPO3\\CMS\\Extbase\\Configuration\\ConfigurationManager');
		$extbaseFrameworkConfiguration = $configurationManager->getConfiguration(\TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT);
		$pageId = $extbaseFrameworkConfiguration['plugin.']['tx_sgregionpages_pi1.']['settings.']['pids.']['overview'];
		
        if ($indexerConfig['type'] === $this->indexerConfigurationKey) {
            $i = 0;
            foreach($this->getContent() as $record) {
                $title    			= strip_tags($record['title']);
                $headline 			= strip_tags($record['headline']);
                $teaser  			= strip_tags($record['teaser']);
                $content  			= strip_tags($record['content']);
                $abstract 			= $content;
                $fullContent 		= !empty($content) ? $content : (!empty($headline) ? $headline : (!empty($teaser) ? $teaser : ''));
                $params 			= '&tx_sgregionpages_pi1[controller]=Display&tx_sgregionpages_pi1[action]=detail';
                foreach(explode('~', $record['tree']) as $k=>$v) 
					$params .= '&tx_sgregionpages_pi1[region][' . $k . ']=' . $v;
                $tags 				= '';
                foreach(explode(' ', $title) as $k=>$v) 
					$tags .= ($k > 0 ? ',' : '') . '#' . $v . '#';
                $additionalFields 	= array(
                    'sortdate' => $record['crdate'],
                    'orig_uid' => $record['uid'],
                    'orig_pid' => $record['pid'],
                    'sortdate' => $record['tstamp'],
                );
                $dummy = $indexerObject->storeInIndex(
                    $indexerConfig['storagepid'],
                    $title,
                    $this->indexerConfigurationKey,
                    ($pageId ? $pageId : $indexerConfig['storagepid']),
                    $fullContent,
                    $tags,
                    $params,
                    $abstract,
                    $record['sys_language_uid'],
                    $record['starttime'],
                    $record['endtime'],
                    0,
                    false,
                    $additionalFields
                );
                $i++;
            }
            $content = '<p><b>Custom Indexer "' . $indexerConfig['title'] . '": ' . $i . ' Elements have been indexed.</b></p>';
            return $content;
        }
    }
}
