<?php

namespace SG\SgRegionpages\Frontend\Generator;

use TYPO3\CMS\Core\Site\Entity\Site;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Seo\Event\ModifyUrlForCanonicalTagEvent;

class CanonicalGenerator extends \TYPO3\CMS\Seo\Canonical\CanonicalGenerator
{
    public function generate(): string
    {
        $event = $this->eventDispatcher->dispatch(new ModifyUrlForCanonicalTagEvent(''));
        $href = $event->getUrl();

        if (empty($href) && (int)$this->typoScriptFrontendController->page['no_index'] === 1) {
            return '';
        }

        if (empty($href)) {
            // 1) Check if page show content from other page
            $href = $this->checkContentFromPid();
        }
        if (empty($href)) {
            // 2) Check if page has canonical URL set
            $href = $this->checkForCanonicalLink();
        }
        if (empty($href)) {
            // 3) Fallback, create canonical URL
            $href = $this->checkDefaultCanonical();
        }

        if (!empty($href)) {
            if ($this->isRegionpagesPage()) {
                $href = $this->removeCHashFromHref($href);
            }

            $canonical = '<link ' . GeneralUtility::implodeAttributes([
                    'rel' => 'canonical',
                    'href' => $href
                ], true) . '/>' . LF;
            $this->typoScriptFrontendController->additionalHeaderData[] = $canonical;
            return $canonical;
        }
        return '';
    }

    private function getSite(): ?Site
    {
        return ($GLOBALS[ 'TYPO3_REQUEST' ]->getAttribute('site') instanceof Site) ?
            $GLOBALS[ 'TYPO3_REQUEST' ]->getAttribute('site') : null;
    }

    private function getRegionpagesPageUid(): int
    {
        $site = $this->getSite();
        if ($site instanceof Site) {
            $configuration = $site->getConfiguration();
            if (isset($configuration[ 'sgRegionPagesPid' ]) && intval($configuration[ 'sgRegionPagesPid' ]) > 0) {
                return intval($configuration[ 'sgRegionPagesPid' ]);
            }
        }
        return 0;
    }

    private function getPageId(): int
    {
        return (isset($this->typoScriptFrontendController->page[ 'uid' ])) ?
            $this->typoScriptFrontendController->page[ 'uid' ] : 0;
    }

    private function isRegionpagesPage(): bool
    {
        return $this->getPageId() === $this->getRegionpagesPageUid();
    }

    private function removeCHashFromHref($href): string
    {
        $cHashStartIndex = strpos($href, '?cHash=');
        if ($cHashStartIndex === false) {
            $cHashStartIndex = strpos($href, '&cHash=');
        }

        if ($cHashStartIndex !== false) {
            $href = substr($href, 0, $cHashStartIndex);
        }

        if (strpos($href, '?') === false) {
            // we have no query params, lets add a trailing slash
            $href = rtrim($href, '/') . '/';
        }
        return $href;
    }
}
