<?php

namespace SG\SgRegionpages\Hooks;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Database\Query\Restriction\DeletedRestriction;
use TYPO3\CMS\Core\Database\Query\Restriction\HiddenRestriction;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;

class KesearchRegionpages
{
    /**
     * @var string
     */
    protected $indexerConfigurationKey = 'regionpagesindexer';

    /**
     * Adds the custom indexer to the TCA of indexer configurations, so that
     * it's selectable in the backend as an indexer type when you create a
     * new indexer configuration.
     *
     * @param string[] $params
     * @param mixed $pObj
     */
    public function registerIndexerConfiguration(array $params, $pObj): void
    {
        // Set a name and an icon for your indexer.
        $customIndexer = [
            '[CUSTOM] Regionpages-Indexer (ext:regionpages)',
            $this->indexerConfigurationKey,
            'EXT:sg_regionpages/Resources/Public/Icons/PluginIcon.png'
        ];
        $params['items'][] = $customIndexer;
    }

    /**
     * Custom indexer for ke_search
     *
     * @param   mixed $indexerConfig Configuration from TYPO3 Backend
     * @param   mixed $indexerObject Reference to indexer class.
     * @return  mixed Message containing indexed elements
     */
    public function customIndexer($indexerConfig, $indexerObject)
    {
        if ($indexerConfig['type'] === $this->indexerConfigurationKey) {
            $content = '';
            $this->connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionByName('Default');
            $query = $this->connection->createQueryBuilder();
            $query
                ->getRestrictions()
                ->add(GeneralUtility::makeInstance(DeletedRestriction::class))
                ->add(GeneralUtility::makeInstance(HiddenRestriction::class));
            $statement = $query
                ->select('*')
                ->from('tx_sgregionpages_domain_model_contentcollection')
                ->where($query->expr()->in('parent', [0]))
                ->execute();
            $i = 0;
            while ($record = $statement->fetch()) {
                $title    			= strip_tags($record['title']);
                $abstract 			= '';
                $content  			= 'Wohnen und Wohlfühlen in ' . $title;
                $fullContent 		= $title . "\n" . $abstract . "\n" . $content;
                $params 			= '/' . $record['slug'];
                $tags 				= '#regionpages#,#regionpage#';
                $additionalFields 	= array(
                    'sortdate' => $record['crdate'],
                    'orig_uid' => $record['uid'],
                    'orig_pid' => $record['pid'],
                    'sortdate' => $record['tstamp'],
                );
                $record['fe_group'] = $record['fe_group'] ? $record['fe_group'] : 0;
                $id = $indexerObject->storeInIndex(
                    $indexerConfig['storagepid'],
                    $title,
                    $this->indexerConfigurationKey,
                    $indexerConfig['targetpid'],
                    $fullContent,
                    $tags,
                    $params
                    $abstract,
                    $record['sys_language_uid'],
                    $record['starttime'],
                    $record['endtime'],
                    $record['fe_group'],
                    false,
                    $additionalFields
                );
                $i++;
            }
            $content = '<p><b>Custom Indexer "' . $indexerConfig['title'] . '": ' . $i . ' Elements have been indexed.</b></p>';
            return $content;
        }
    }
}
