<?php
namespace SG\SgRegionpages\Domain\Model;

use SG\SgRegionpages\Domain\Repository\ContentCollectionRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\QueryResult;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/***
 *
 * This file is part of the "s.g.regionpages" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019 Daniel Hoffmann <hoffmann@smply.gd>, smply.gd GmbH
 *           Marc Saleiko <saleiko@smply.gd>, smply.gd GmbH
 *
 ***/
/**
 * ContentCollection
 */
class ContentCollection extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * slug
     *
     * @var string
     */
    protected $slug = '';

    /**
     * parent
     *
     * @var \SG\SgRegionpages\Domain\Model\ContentCollection
     */
    protected $parent = null;

    /**
     * titleImage
     *
     * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
     */
    protected $titleImage = null;

    /**
     * headline
     *
     * @var string
     */
    protected $headline = '';

    /**
     * teaser
     *
     * @var string
     */
    protected $teaser = '';

    /**
     * additionalTeaser
     *
     * @var string
     */
    protected $additionalTeaser = '';

    /**
     * @var string
     */
    protected $redirectLink = '';

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgRegionpages\Domain\Model\ContentPane>
     */
    protected $contentpanes;

    /**
     * @var null|\SG\SgEstateCore\Domain\Model\Ort
     */
    protected $sgEstateCityForList = null;

    /**
     * @var null|\SG\SgEstateCore\Domain\Model\Stadtteil
     */
    protected $sgEstateDistrictForList = null;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Ort>
     */
    protected $sgEstateCities;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Stadtteil>
     */
    protected $sgEstateDistricts;

    /**
     * @var bool
     */
    protected $showMapInsteadOfImage = false;

    protected function __construct()
    {
        $this->contentpanes = new ObjectStorage();
        $this->sgEstateCities = new ObjectStorage();
        $this->sgEstateDistricts = new ObjectStorage();
    }

    /**
     * Returns the title
     *
     * @return string $title
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     *
     * @param string $title
     * @return void
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * Returns the titleImage
     *
     * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference $titleImage
     */
    public function getTitleImage()
    {
        return $this->titleImage;
    }

    /**
     * Sets the titleImage
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $titleImage
     * @return void
     */
    public function setTitleImage(\TYPO3\CMS\Extbase\Domain\Model\FileReference $titleImage)
    {
        $this->titleImage = $titleImage;
    }

    /**
     * Returns the headline
     *
     * @return string $headline
     */
    public function getHeadline()
    {
        return $this->headline;
    }

    /**
     * Sets the headline
     *
     * @param string $headline
     * @return void
     */
    public function setHeadline($headline)
    {
        $this->headline = $headline;
    }

    /**
     * Returns the teaser
     *
     * @return string $teaser
     */
    public function getTeaser()
    {
        return $this->teaser;
    }

    /**
     * Sets the teaser
     *
     * @param string $teaser
     * @return void
     */
    public function setTeaser($teaser)
    {
        $this->teaser = $teaser;
    }

    /**
     * Returns the additionalTeaser
     *
     * @return string $additionalTeaser
     */
    public function getAdditionalTeaser()
    {
        return $this->additionalTeaser;
    }

    /**
     * Sets the additionalTeaser
     *
     * @param string $additionalTeaser
     * @return void
     */
    public function setAdditionalTeaser($additionalTeaser)
    {
        $this->additionalTeaser = $additionalTeaser;
    }

    /**
     * @return string
     */
    public function getSlug(): string
    {
        return $this->slug;
    }

    /**
     * @param string $slug
     */
    public function setSlug(string $slug): void
    {
        $this->slug = $slug;
    }

    /**
     * @return ContentCollection
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * @param ContentCollection $parent
     */
    public function setParent(self $parent): void
    {
        $this->parent = $parent;
    }

    /**
     * @return QueryResult
     */
    public function getChildren(): QueryResult
    {
        $contentCollectionRepository = GeneralUtility::makeInstance(ContentCollectionRepository::class);
        return $contentCollectionRepository->findByParent($this->getUid());
    }

    /**
     * @return string
     */
    public function getRedirectLink(): string
    {
        return $this->redirectLink;
    }

    /**
     * @param string $redirectLink
     */
    public function setRedirectLink(string $redirectLink): void
    {
        $this->redirectLink = $redirectLink;
    }

    /**
     * @return string
     */
    public function getFullSlug()
    {
        $fullSlug = '/' . $this->getSlug();
        if ($this->getParent() instanceof self) {
            $fullSlug = $this->getParent()->getFullSlug() . $fullSlug;
        }
        return $fullSlug;
    }

    /**
     * @return ObjectStorage
     */
    public function getContentPanes(): ObjectStorage
    {
        return $this->contentpanes;
    }

    /**
     * @param ObjectStorage $contentpanes
     */
    public function setContentPanes(ObjectStorage $contentpanes): void
    {
        $this->contentpanes = $contentpanes;
    }

    /**
     * @return ObjectStorage
     */
    public function getSgEstateCities(): ObjectStorage
    {
        return $this->sgEstateCities;
    }

    /**
     * @param ObjectStorage $sgEstateCities
     */
    public function setSgEstateCities(ObjectStorage $sgEstateCities): void
    {
        $this->sgEstateCities = $sgEstateCities;
    }

    /**
     * @return ObjectStorage
     */
    public function getSgEstateDistricts(): ObjectStorage
    {
        return $this->sgEstateDistricts;
    }

    /**
     * @param ObjectStorage $sgEstateDistricts
     */
    public function setSgEstateDistricts(ObjectStorage $sgEstateDistricts): void
    {
        $this->sgEstateDistricts = $sgEstateDistricts;
    }

    /**
     * @return \SG\SgEstateCore\Domain\Model\Ort|null
     */
    public function getSgEstateCityForList()
    {
        return $this->sgEstateCityForList;
    }

    /**
     * @param \SG\SgEstateCore\Domain\Model\Ort|null $sgEstateCityForList
     */
    public function setSgEstateCityForList($sgEstateCityForList)
    {
        $this->sgEstateCityForList = $sgEstateCityForList;
    }

    /**
     * @return \SG\SgEstateCore\Domain\Model\Stadtteil|null
     */
    public function getSgEstateDistrictForList()
    {
        return $this->sgEstateDistrictForList;
    }

    /**
     * @param \SG\SgEstateCore\Domain\Model\Stadtteil|null $sgEstateDistrictForList
     */
    public function setSgEstateDistrictForList($sgEstateDistrictForList)
    {
        $this->sgEstateDistrictForList = $sgEstateDistrictForList;
    }

    /**
     * @return bool
     */
    public function getShowMapInsteadOfImage()
    {
        return $this->showMapInsteadOfImage;
    }

    /**
     * @param bool $showMapInsteadOfImage
     */
    public function setShowMapInsteadOfImage($showMapInsteadOfImage)
    {
        $this->showMapInsteadOfImage = $showMapInsteadOfImage;
    }
}
