<?php

namespace SG\SgRegionpages\Frontend\PageTitle;

use SG\SgRegionpages\Domain\Model\ContentCollection;
use TYPO3\CMS\Core\MetaTag\MetaTagManagerRegistry;
use TYPO3\CMS\Core\PageTitle\AbstractPageTitleProvider;

/***
 * This file is part of the "s.g.regionpages" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019 Daniel Hoffmann <hoffmann@smply.gd>, smply.gd GmbH
 *           Marc Saleiko <saleiko@smply.gd>, smply.gd GmbH
 *
 * Class ContentCollectionPageTitleProvider
 *
 * Overrides the page title. Should be used in the detail action
 * of the DisplayController. Must be registered in typoscript.
 *
 * @package SG\SgRegionpages\Frontend\PageTitle
 */
class ContentCollectionPageTitleProvider extends AbstractPageTitleProvider
{

    /** @var MetaTagManagerRegistry  */
    private $metaTagManagerRegistry = null;

    public function injectMetaTagManagerRegistry(MetaTagManagerRegistry $metaTagManagerRegistry)
    {
        $this->metaTagManagerRegistry = $metaTagManagerRegistry;
    }

    public function setTitle(ContentCollection $contentCollection): void
    {
        if ($contentCollection instanceof ContentCollection) {
            $this->title = $contentCollection->getTitle();
            $this->metaTagManagerRegistry
                ->getManagerForProperty('og:title')
                ->addProperty('og:title', $this->getTitle());
        }
    }
}
