<?php
$contentCollectionTCA = [
    'ctrl' => [
        'title' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection',
        'label' => 'title',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'sortby' => 'sorting',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'title,headline,teaser,additional_teaser',
        'iconfile' => 'EXT:sg_regionpages/Resources/Public/Icons/tx_sgregionpages_domain_model_contentcollection.gif'
    ],
    'interface' => [
        'showRecordFieldList' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, title, slug, parent, redirect_link, keywords, description, title_image, headline, teaser, additional_teaser, contentelements, contentpanes, sg_estate_city_for_list, sg_estate_district_for_list, sg_estate_cities, sg_estate_districts, show_map_instead_of_image',
    ],
    'types' => [
        '1' => [
            'showitem' => '
            sys_language_uid, l10n_parent, l10n_diffsource, hidden, title, slug, parent, redirect_link, keywords, description, title_image, headline, teaser, additional_teaser,
            --div--;Strukturinhalt,contentpanes,
            --div--;Inhaltselemente,contentelements,
            --div--;sg.estate,sg_estate_city_for_list, sg_estate_district_for_list, sg_estate_cities, sg_estate_districts, show_map_instead_of_image,
            --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'special' => 'languages',
                'items' => [
                    [
                        'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.allLanguages',
                        -1,
                        'flags-multiple'
                    ]
                ],
                'default' => 0,
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'default' => 0,
                'items' => [
                    ['', 0],
                ],
                'foreign_table' => 'tx_sgregionpages_domain_model_contentcollection',
                'foreign_table_where' => 'AND {#tx_sgregionpages_domain_model_contentcollection}.{#pid}=###CURRENT_PID### AND {#tx_sgregionpages_domain_model_contentcollection}.{#sys_language_uid} IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
            'config' => [
                'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        0 => '',
                        1 => '',
                        'invertStateDisplay' => true
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime,int',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
        ],
        'title' => [
            'exclude' => true,
            'label' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection.title',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim,required'
            ],
        ],
        'slug' => [
            'exclude' => true,
            'label' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection.slug',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim,required'
            ],
        ],
        'parent' => [
            'exclude' => true,
            'label' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection.parent',
            'config' => [
                'minitems' => 0,
                'maxitems' => 1,
                'type' => 'select',
                'renderType' => 'selectTree',
                'foreign_table' => 'tx_sgregionpages_domain_model_contentcollection',
                'foreign_table_where' => ' AND tx_sgregionpages_domain_model_contentcollection.sys_language_uid IN (-1,0) ORDER BY tx_sgregionpages_domain_model_contentcollection.sorting ASC',
                'treeConfig' => [
                    'parentField' => 'parent',
                    'appearance' => [
                        'expandAll' => true,
                        'showHeader' => true,
                        'maxLevels' => 99,
                    ],
                ],
                'default' => 0
            ]
        ],
        'redirect_link' => [
            'exclude' => true,
            'label' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection.redirect_link',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputLink',
                'fieldControl' => [
                    'linkPopup' => [
                        'options' => [
                            'blindLinkOptions' => 'folder,file,mail,spec,url',
                            'blindLinkFields' => 'class,params,target,title',
                        ]
                    ]
                ]
            ],
        ],
        'keywords' => [
            'exclude' => true,
            'label' => 'Meta Keywords',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'description' => [
            'exclude' => true,
            'label' => 'Meta Description',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim'
            ],
        ],
        'title_image' => [
            'exclude' => true,
            'label' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection.title_image',
            'config' => \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::getFileFieldTCAConfig(
                'title_image',
                [
                    'appearance' => [
                        'createNewRelationLinkTitle' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:images.addFileReference'
                    ],
                    'foreign_types' => [
                        '0' => [
                            'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                        ],
                        \TYPO3\CMS\Core\Resource\File::FILETYPE_TEXT => [
                            'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                        ],
                        \TYPO3\CMS\Core\Resource\File::FILETYPE_IMAGE => [
                            'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                        ],
                        \TYPO3\CMS\Core\Resource\File::FILETYPE_AUDIO => [
                            'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                        ],
                        \TYPO3\CMS\Core\Resource\File::FILETYPE_VIDEO => [
                            'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                        ],
                        \TYPO3\CMS\Core\Resource\File::FILETYPE_APPLICATION => [
                            'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                        ]
                    ],
                    'maxitems' => 1
                ],
                $GLOBALS['TYPO3_CONF_VARS']['GFX']['imagefile_ext']
            ),
        ],
        'headline' => [
            'exclude' => true,
            'label' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection.headline',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim,required'
            ],
        ],
        'teaser' => [
            'exclude' => true,
            'label' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection.teaser',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim,required'
            ]
        ],
        'additional_teaser' => [
            'exclude' => true,
            'label' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection.additional_teaser',
            'config' => [
                'type' => 'text',
                'enableRichtext' => true,
                'richtextConfiguration' => 'default',
                'fieldControl' => [
                    'fullScreenRichtext' => [
                        'disabled' => false,
                    ],
                ],
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
            ],
        ],
        'contentelements' => [
            'exclude' => true,
            'label' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection.ces',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tt_content',
                'foreign_field' => 'tx_sgregionpages_relation_contentcollection_ttcontent',
                'foreign_record_defaults' => [
                    'colPos' => '999'
                ],
                'maxitems'      => 9999,
                'appearance' => [
                    'collapseAll' => true,
                    'levelLinksPosition' => 'top',
                    'showSynchronizationLink' => 1,
                    'showPossibleLocalizationRecords' => 1,
                    'showAllLocalizationLink' => 1
                ],
            ],
        ],
        'contentpanes' => [
            'label' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection.panes',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_sgregionpages_domain_model_contentpane',
                'foreign_field' => 'contentcollection',
                'maxitems' => 9999,
                'appearance' => [
                    'useSortable' => true,
                    'collapseAll' => true,
                    'levelLinksPosition' => 'top',
                    'showSynchronizationLink' => true,
                    'showAllLocalizationLink' => true,
                    'showPossibleLocalizationRecords' => true,
                    'showRemovedLocalizationRecords' => false,
                    'expandSingle' => true,
                    'enabledControls' => [
                        'localize' => true,
                    ]
                ],
                'behaviour' => [
                    'mode' => 'select',
                    'localizeChildrenAtParentLocalization' => true,
                ]
            ],
        ],
    ],
];
if (\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::isLoaded('sg_estate_core')) {
    $contentCollectionTCA['columns']['sg_estate_city_for_list'] = [
        'label' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection.city_for_list_connection',
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'foreign_table' => 'tx_sgestatecore_domain_model_ort',
            'multiple' => 0,
            'items' => [
                ['', 0],
            ],
            'default' => 0
        ],
    ];
    $contentCollectionTCA['columns']['sg_estate_district_for_list'] = [
        'label' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection.district_for_list_connection',
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'foreign_table' => 'tx_sgestatecore_domain_model_stadtteil',
            'multiple' => 0,
            'items' => [
                ['', 0],
            ],
            'default' => 0
        ],
    ];
    $contentCollectionTCA['columns']['sg_estate_cities'] = [
        'label' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection.cities',
        'config' => [
            'type' => 'select',
            'renderType' => 'selectMultipleSideBySide',
            'foreign_table' => 'tx_sgestatecore_domain_model_ort',
            'MM' => 'tx_sgregionpages_contentpane_city_mm',
            'size' => 10,
            'autoSizeMax' => 30,
            'maxitems' => 9999,
            'multiple' => 0,
            'enableMultiSelectFilterTextfield' => true,
            'fieldControl' => [
                'editPopup' => [
                    'disabled' => true,
                ],
                'addRecord' => [
                    'disabled' => true,
                ],
                'listModule' => [
                    'disabled' => true,
                ],
            ],
        ],
    ];
    $contentCollectionTCA['columns']['sg_estate_districts'] = [
        'label' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection.districts',
        'config' => [
            'type' => 'select',
            'renderType' => 'selectMultipleSideBySide',
            'foreign_table' => 'tx_sgestatecore_domain_model_stadtteil',
            'foreign_table_where' => 'ORDER BY ort, bezeichner',
            'MM' => 'tx_sgregionpages_contentpane_district_mm',
            'size' => 10,
            'autoSizeMax' => 30,
            'maxitems' => 9999,
            'multiple' => 0,
            'enableMultiSelectFilterTextfield' => true,
            'fieldControl' => [
                'editPopup' => [
                    'disabled' => true,
                ],
                'addRecord' => [
                    'disabled' => true,
                ],
                'listModule' => [
                    'disabled' => true,
                ],
            ],
        ],
    ];
    $contentCollectionTCA['columns']['show_map_instead_of_image'] =[
        'exclude' => 1,
        'label' => 'LLL:EXT:sg_regionpages/Resources/Private/Language/locallang_db.xlf:tx_sgregionpages_domain_model_contentcollection.show_map_instead_of_image',
        'config' => [
            'type' => 'check',
        ],
    ];
}
return $contentCollectionTCA;
