<?php
namespace SG\SgRegionpages\Controller;

use SG\SgRegionpages\Domain\Model\ContentCollection;
use SG\SgRegionpages\Domain\Repository\ContentCollectionRepository;
use SG\SgRegionpages\Frontend\PageTitle\ContentCollectionPageTitleProvider;
use TYPO3\CMS\Core\LinkHandling\LinkService;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Core\MetaTag\MetaTagManagerRegistry;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/***
 *
 * This file is part of the "s.g.regionpages" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019 Daniel Hoffmann <hoffmann@smply.gd>, smply.gd GmbH
 *           Marc Saleiko <saleiko@smply.gd>, smply.gd GmbH
 *
 ***/
class DisplayController extends ActionController
{

    /** @var ContentCollectionRepository  */
    private $contentCollectionRepository = null;

    /** @var ContentCollectionPageTitleProvider  */
    private $contentCollectionPageTitleProvider = null;

    public function __construct(
        ContentCollectionRepository $contentCollectionRepository,
        ContentCollectionPageTitleProvider $contentCollectionPageTitleProvider
    )
    {
        $this->contentCollectionRepository = $contentCollectionRepository;
        $this->contentCollectionPageTitleProvider = $contentCollectionPageTitleProvider;
    }

    public function overviewAction()
    {
        if (!$this->request->hasArgument('region')) {
            $items = $this->contentCollectionRepository->findByParent('');
            $this->view->assign('items', $items);
        } else {
            $this->forward('detail');
        }
    }

    public function detailAction()
    {
        if ($this->request->hasArgument('region')) {
            $regions = $this->request->getArgument('region');
            $contentCollection = $this->contentCollectionRepository->findOneByRegionArray($regions);
            if ($contentCollection instanceof ContentCollection) {
                if ($contentCollection->getRedirectLink() != '') {
                    /**
                     * @var $linkService LinkService
                     */
                    $linkService = $this->objectManager->get('TYPO3\CMS\Core\LinkHandling\LinkService');
                    $link = $linkService->resolve($contentCollection->getRedirectLink());
                    $uriBuilder = $this->uriBuilder;
                    if ($link['type'] == 'page' && is_numeric($link['pageuid']) && $link['pageuid'] > 0) {
                        $uri = $uriBuilder->setTargetPageUid($link['pageuid'])->build();
                    } else {
                        $uri = $uriBuilder->setTargetPageUid($this->settings['pids']['overview'])->build();
                    }
                    $this->redirectToUri($uri, 0);
                } else {
                    if (\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::isLoaded('sg_estate_core') && ($contentCollection->getSgEstateCities()->count() > 0 || $contentCollection->getSgEstateDistricts()->count() > 0)) {
                        /**
                         * @var \SG\SgEstateCore\Domain\Model\Filter $filter
                         * @var \SG\SgEstateCore\Domain\Repository\ImmobilieRepository $realtyRepository
                         */
                        $filter = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Filter');
                        $realtyRepository = $this->objectManager->get('SG\SgEstateCore\Domain\Repository\ImmobilieRepository');

                        foreach ($contentCollection->getSgEstateCities() as $city) {
                            $filter->addOrt($city);
                        }
                        foreach ($contentCollection->getSgEstateDistricts() as $district) {
                            $filter->addStadtteil($district);
                        }
                        $realties = $realtyRepository->findAllWithFilter($filter);

                        $this->view->assign('sgEstateRealties', $realties);
                    } else {
                        $this->view->assign('sgEstateRealties', null);
                    }

                    // sets the page title accordingly. Needs to be registered in typoscript.
                    $this->contentCollectionPageTitleProvider->setTitle($contentCollection);

                    $metaTagManager = GeneralUtility::makeInstance(MetaTagManagerRegistry::class);
                    $metaTagManager->getManagerForProperty('keywords')->addProperty('keywords', $contentCollection->getKeywords());
                    $metaTagManager->getManagerForProperty('description')->addProperty('description', $contentCollection->getDescription());

                    $this->view->assign('contentCollection', $contentCollection);
                    $this->view->assign('subCollections', $this->contentCollectionRepository->findByParent($contentCollection));
                    $this->view->assign('aggregatedFilterData', json_encode($this->getAggregatedFilterData()));
                }
            } else {
                $uriBuilder = $this->uriBuilder;
                $uri = $uriBuilder->setTargetPageUid($this->settings['pids']['overview'])->build();
                $this->redirectToUri($uri, 0);
            }
        } else {
            $uriBuilder = $this->uriBuilder;
            $uri = $uriBuilder->setTargetPageUid($this->settings['pids']['overview'])->build();
            $this->redirectToUri($uri, 0);
        }
    }

    private function getAggregatedFilterData()
    {
        return [
            'size' => isset($this->settings['sgEstate']['slider']['size']['value']) ? $this->settings['sgEstate']['slider']['size']['value'] : 1,
            'rooms' => isset($this->settings['sgEstate']['slider']['room']['value']) ? $this->settings['sgEstate']['slider']['room']['value'] : 1,
            'rent' => isset($this->settings['sgEstate']['slider']['amount']['value']) ? $this->settings['sgEstate']['slider']['amount']['value'] : 1
        ];
    }
}
