<?php
namespace SG\SgRegionpages\Domain\Repository;


use SG\SgRegionpages\Domain\Model\ContentCollection;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;

/***
 *
 * This file is part of the "s.g.regionpages" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019 Daniel Hoffmann <hoffmann@smply.gd>, smply.gd GmbH
 *           Marc Saleiko <saleiko@smply.gd>, smply.gd GmbH
 *
 ***/
/**
 * The repository for ContentCollections
 */
class ContentCollectionRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
    protected $defaultOrderings = [
        'title' => QueryInterface::ORDER_ASCENDING,
    ];

    public function initializeObject()
    {
        /** @var $querySettings \TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings */
        $querySettings = $this->objectManager->get('TYPO3\\CMS\\Extbase\\Persistence\\Generic\\Typo3QuerySettings');
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }

    public function findOneByRegionArray(Array $regions){
        if (count($regions) > 0){
            $regions = array_reverse($regions);
            $slugs = $regions;
            unset($slugs[0]);
            $contentCollectionsForLastSlug = $this->findBySlug($regions[0]);
            if ($contentCollectionsForLastSlug->count() == 0){
                return false;
            }elseif ($contentCollectionsForLastSlug->count() == 1){
                if (count($slugs) > 0){
                    if ($this->isCorrectContentCollectionForSlugs($contentCollectionsForLastSlug->getFirst(), $slugs)){
                        return $contentCollectionsForLastSlug->getFirst();
                    }else{
                        return false;
                    }
                }else{
                    return $contentCollectionsForLastSlug->getFirst();
                }
            }else{
                foreach ($contentCollectionsForLastSlug as $contentCollection){
                    if ($this->isCorrectContentCollectionForSlugs($contentCollection, $slugs)){
                        return $contentCollection;
                    }
                }
                return false;
            }
        }else{
            return false;
        }
    }

    private function isCorrectContentCollectionForSlugs(ContentCollection $contentCollection, array $slugs){
        $tempContentCollection = $contentCollection;
        $iterationCount = 1;
        $parent = $tempContentCollection->getParent();
        foreach ($slugs as $slug){
            if ($parent->getSlug() == $slug){
                if ($parent->getParent() instanceof ContentCollection){
                    $parent = $parent->getParent();
                }elseif($iterationCount == count($slugs)){
                    return true;
                }else{
                    return false;
                }
            }else{
                return false;
            }
            $iterationCount++;
        }
    }

}
