<?php
namespace SG\SgRegionpages\Controller;

use SG\SgRegionpages\Domain\Model\ContentCollection;
use SG\SgRegionpages\Domain\Repository\ContentCollectionRepository;
use TYPO3\CMS\Core\LinkHandling\LinkService;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

/***
 *
 * This file is part of the "s.g.regionpages" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019 Daniel Hoffmann <hoffmann@smply.gd>, smply.gd GmbH
 *           Marc Saleiko <saleiko@smply.gd>, smply.gd GmbH
 *
 ***/
/**
 * RegionController
 */
class DisplayController extends ActionController
{

    /**
     * contentCollectionRepository
     * 
     * @var \SG\SgRegionpages\Domain\Repository\ContentCollectionRepository
     *
     */
    private $contentCollectionRepository = null;

    /**
     * @param ContentCollectionRepository $contentCollectionRepository
     */
    public function injectContentCollectionRepository(ContentCollectionRepository $contentCollectionRepository){
        $this->contentCollectionRepository = $contentCollectionRepository;
    }

    public function overviewAction(){
        if (!$this->request->hasArgument('region')){
            $items = $this->contentCollectionRepository->findByParent('');
            $this->view->assign('items', $items);
        }else{
            $this->forward('detail');
        }
    }

    public function detailAction(){
        if ($this->request->hasArgument('region')){
            $regions = $this->request->getArgument('region');
            $contentCollection = $this->contentCollectionRepository->findOneByRegionArray($regions);
            if ($contentCollection instanceof ContentCollection){
                if ($contentCollection->getRedirectLink() != ''){
                    /**
                     * @var $linkService LinkService
                     */
                    $linkService = $this->objectManager->get('TYPO3\CMS\Core\LinkHandling\LinkService');
                    $link = $linkService->resolve($contentCollection->getRedirectLink());
                    $uriBuilder = $this->uriBuilder;
                    if ($link['type'] == 'page' && is_numeric($link['pageuid']) && $link['pageuid'] > 0){
                        $uri = $uriBuilder->setTargetPageUid($link['pageuid'])->build();
                    }else{
                        $uri = $uriBuilder->setTargetPageUid($this->settings['pids']['overview'])->build();
                    }
                    $this->redirectToUri($uri,0);
                }else{
                    $this->view->assign('contentCollection', $contentCollection);
                    $this->view->assign('subCollections', $this->contentCollectionRepository->findByParent($contentCollection));
                }
            }else{
                $uriBuilder = $this->uriBuilder;
                $uri = $uriBuilder->setTargetPageUid($this->settings['pids']['overview'])->build();
                $this->redirectToUri($uri,0);
            }
        }else{
            $uriBuilder = $this->uriBuilder;
            $uri = $uriBuilder->setTargetPageUid($this->settings['pids']['overview'])->build();
            $this->redirectToUri($uri,0);
        }
    }
}
